package ly.warp.sdk.views.dialogs;

import android.app.Activity;
import android.content.Context;
import android.view.View;

import java.util.Date;

public class RateDialog {

    private static RateDialog singleton;

    private Context context;

    private final RateDialogOptions options = new RateDialogOptions();

    private int installDate = -1;

    private int launchTimes = -1;

    private int remindInterval = 1;

    private int eventsTimes = -1;

    private boolean isDebug = false;

    public RateDialog(Context context) {
        this.context = context;
    }

    public static RateDialog with(Context context) {
        if (singleton == null) {
            synchronized (RateDialog.class) {
                if (singleton == null) {
                    singleton = new RateDialog(context);
                }
            }
        }
        return singleton;
    }

    public void launch() {
        if(RatePreferenceHelper.isFirstLaunch(context)) {
            RatePreferenceHelper.setInstallDate(context);
        }

        RatePreferenceHelper.setLaunchTimes(context, RatePreferenceHelper.getLaunchTimes(context) + 1);
    }

    public static boolean showRateDialogIfMeetsConditions(Activity activity) {
        boolean isMeetsConditions = singleton.isDebug || singleton.shouldShowRateDialog();
        if (isMeetsConditions) {
            singleton.showRateDialog(activity);
        }
        return isMeetsConditions;
    }

    public static boolean passSignificantEventAndConditions(Activity activity) {
        return passSignificantEvent(activity, singleton.shouldShowRateDialog());
    }

    private static boolean passSignificantEvent(Activity activity, boolean shouldShow) {
        int eventTimes = RatePreferenceHelper.getEventTimes(activity);
        RatePreferenceHelper.setEventTimes(activity, ++eventTimes);
        boolean isMeetsConditions = singleton.isDebug || (singleton.isOverEventTimes() && shouldShow);
        if (isMeetsConditions) {
            singleton.showRateDialog(activity);
        }
        return isMeetsConditions;
    }

    public RateDialog clearPreferenceSettings() {
        RatePreferenceHelper.setAgreeShowDialog(context, true);
        RatePreferenceHelper.clearSharedPreferences(context);
        return this;
    }

    private static boolean isOverDate(long targetDate, int threshold) {
        return new Date().getTime() - targetDate >= threshold * 24 * 60 * 60 * 1000;
    }

    public boolean shouldShowRateDialog() {
        return RatePreferenceHelper.getIsAgreeShowDialog(context) &&
                isOverLaunchTimes() &&
                isOverInstallDate() &&
                isOverIntervalDate();
    }

    public boolean isOverInstallDate() {
        if(installDate == -1)
            return true;

        return isOverDate(RatePreferenceHelper.getInstallDate(context), installDate);
    }

    public boolean isOverIntervalDate() {
        return isOverDate(RatePreferenceHelper.getRemindIntervalDate(context), remindInterval);
    }

    public boolean isOverLaunchTimes() {
        if(launchTimes == -1)
            return true;

        return RatePreferenceHelper.getLaunchTimes(context) >= launchTimes;
    }

    public boolean isOverEventTimes() {
        if(eventsTimes == -1)
            return true;

        return RatePreferenceHelper.getEventTimes(context) >= launchTimes;
    }

    public RateDialog setInstallDate(int installDate) {
        this.installDate = installDate;
        return this;
    }

    public RateDialog setLaunchTimes(int launchTimes) {
        this.launchTimes = launchTimes;
        return this;
    }

    public RateDialog setRemindInterval(int remindInterval) {
        this.remindInterval = remindInterval;
        return this;
    }

    public RateDialog setEventsTimes(int eventsTimes) {
        this.eventsTimes = eventsTimes;
        return this;
    }

    public RateDialog setShowNeutralButton(boolean isShowNeutralButton) {
        options.setShowNeutralButton(isShowNeutralButton);
        return this;
    }

    public RateDialog setShowTitle(boolean isShowTitle) {
        options.setShowTitle(isShowTitle);
        return this;
    }

    public RateDialog setView(View view) {
        options.setView(view);
        return this;
    }

    public RateDialog setOnClickButtonListener(OnClickButtonListener listener) {
        options.setListener(listener);
        return this;
    }

    public RateDialog setTitle(int resourceId) {
        options.setTitleResId(resourceId);
        return this;
    }

    public RateDialog setTitle(String title) {
        options.setTitleText(title);
        return this;
    }

    public RateDialog setMessage(int resourceId) {
        options.setMessageResId(resourceId);
        return this;
    }

    public RateDialog setMessage(String message) {
        options.setMessageText(message);
        return this;
    }

    public RateDialog setTextPositive(int resourceId) {
        options.setTextPositiveResId(resourceId);
        return this;
    }

    public RateDialog setTextPositive(String positiveText) {
        options.setPositiveText(positiveText);
        return this;
    }

    public RateDialog setTextNeutral(int resourceId) {
        options.setTextNeutralResId(resourceId);
        return this;
    }

    public RateDialog setTextNeutral(String neutralText) {
        options.setNeutralText(neutralText);
        return this;
    }

    public RateDialog setTextNegative(int resourceId) {
        options.setTextNegativeResId(resourceId);
        return this;
    }

    public RateDialog setTextNegative(String negativeText) {
        options.setNegativeText(negativeText);
        return this;
    }

    public RateDialog setCancelable(boolean cancelable) {
        options.setCancelable(cancelable);
        return this;
    }

    public RateDialog setPackageType(String packageType) {
        options.setPackageType(packageType);
        return this;
    }

    public RateDialog setPackageId(String packageId) {
        options.setPackageId(packageId);
        return this;
    }

    public RateDialog setDialogStyle(int style) {
        options.setDialogStyleResId(style);
        return this;
    }

    public RateDialog setIsDebug(boolean isDebug) {
        this.isDebug = isDebug;
        return this;
    }

    public void showRateDialog(Activity activity) {
        if (!activity.isFinishing()) {
            RateDialogManager.with(activity).create(options).show();
        }
    }
}
