package ly.warp.sdk.views.dialogs;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;

import static ly.warp.sdk.utils.constants.WarpConstants.PACKAGE_TITLE_GOOGLE;

final class RateDialogManager {

    private static RateDialogManager singleton;

    private static Context context;

    static Dialog dialog = null;

    private RateDialogManager() {
    }

    private RateDialogManager(Context context) {
        this.context = context;
    }

    public static RateDialogManager with(Context context) {
        if (singleton == null) {
            synchronized (RateDialogManager.class) {
                if (singleton == null) {
                    singleton = new RateDialogManager(context);
                }
            }
        }
        return singleton;
    }

    public RateDialogManager create(final RateDialogOptions options) {
        if (dialog != null)
            return this;

        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.HONEYCOMB) {
            dialog = createDialog(context, options);
        } else {
            dialog = createMaterialDialog(context, options);
        }

        return this;
    }

    public void show() {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.HONEYCOMB) {
            showDialog();
        } else {
            showMaterialDialog();
        }
    }

    static private void showDialog() {
        AlertDialog alertDialog = (AlertDialog) dialog;
        alertDialog.show();

        try {
            final Button button = alertDialog.getButton(AlertDialog.BUTTON_POSITIVE);
            LinearLayout linearLayout = (LinearLayout) button.getParent();
            linearLayout.setOrientation(LinearLayout.HORIZONTAL);
        } catch (Exception ex) {
        }
    }

    static private void showMaterialDialog() {
        androidx.appcompat.app.AlertDialog alertDialog = (androidx.appcompat.app.AlertDialog) dialog;
        alertDialog.show();

        try {
            final Button button = alertDialog.getButton(AlertDialog.BUTTON_POSITIVE);
            LinearLayout linearLayout = (LinearLayout) button.getParent();
            linearLayout.setOrientation(LinearLayout.HORIZONTAL);
        } catch (Exception ex) {
        }
    }

    static private AlertDialog.Builder getDialogBuilder(final Context context) {
        return new AlertDialog.Builder(context);
    }

    static private androidx.appcompat.app.AlertDialog.Builder getMaterialDialogBuilder(final Context context, final RateDialogOptions options) {
        return new androidx.appcompat.app.AlertDialog.Builder(context, options.getDialogStyleResId());
    }

    static private Dialog createDialog(final Context context, final RateDialogOptions options) {
        AlertDialog.Builder builder = getDialogBuilder(context);

        builder.setMessage(options.getMessageText(context));

        if (options.shouldShowTitle()) builder.setTitle(options.getTitleText(context));

        builder.setCancelable(options.getCancelable());

        View view = options.getView();
        if (view != null) builder.setView(view);

        final OnClickButtonListener listener = options.getListener();

        builder.setPositiveButton(options.getPositiveText(context), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                Intent intentToAppstore = null;

                if (options.getPackageType() == PACKAGE_TITLE_GOOGLE)
                    intentToAppstore = IntentHelper.createIntentForGooglePlay(context);

                context.startActivity(intentToAppstore);
                RatePreferenceHelper.setAgreeShowDialog(context, false);
                if (listener != null) listener.onClickButton(which);
            }
        });

        if (options.shouldShowNeutralButton()) {
            builder.setNeutralButton(options.getNeutralText(context), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    RatePreferenceHelper.setRemindIntervalDate(context);
                    if (listener != null) listener.onClickButton(which);
                }
            });
        }

        builder.setNegativeButton(options.getNegativeText(context), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                RatePreferenceHelper.setAgreeShowDialog(context, false);
                if (listener != null) listener.onClickButton(which);
            }
        });

        return builder.create();
    }

    static private Dialog createMaterialDialog(final Context context, final RateDialogOptions options) {
        androidx.appcompat.app.AlertDialog.Builder builder = getMaterialDialogBuilder(context, options);

        builder.setMessage(options.getMessageText(context));

        if (options.shouldShowTitle()) builder.setTitle(options.getTitleText(context));

        builder.setCancelable(options.getCancelable());

        View view = options.getView();
        if (view != null) builder.setView(view);

        final OnClickButtonListener listener = options.getListener();

        builder.setPositiveButton(options.getPositiveText(context), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                Intent intentToAppstore = null;

                if (options.getPackageType() == PACKAGE_TITLE_GOOGLE)
                    intentToAppstore = IntentHelper.createIntentForGooglePlay(context);

                context.startActivity(intentToAppstore);
                RatePreferenceHelper.setAgreeShowDialog(context, false);
                if (listener != null) listener.onClickButton(which);
            }
        });

        if (options.shouldShowNeutralButton()) {
            builder.setNeutralButton(options.getNeutralText(context), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    RatePreferenceHelper.setRemindIntervalDate(context);
                    if (listener != null) listener.onClickButton(which);
                }
            });
        }

        builder.setNegativeButton(options.getNegativeText(context), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                RatePreferenceHelper.setAgreeShowDialog(context, false);
                if (listener != null) listener.onClickButton(which);
            }
        });

        return builder.create();
    }
}