/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.linkcheck.validation;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.linkcheck.validation.LinkValidationItem;
import org.apache.maven.linkcheck.validation.LinkValidationResult;
import org.apache.maven.linkcheck.validation.LinkValidator;

public class HTTPLinkValidator
implements LinkValidator {
    private static Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$linkcheck$validation$HTTPLinkValidator == null ? (class$org$apache$maven$linkcheck$validation$HTTPLinkValidator = HTTPLinkValidator.class$("org.apache.maven.linkcheck.validation.HTTPLinkValidator")) : class$org$apache$maven$linkcheck$validation$HTTPLinkValidator));
    private static final LinkValidationResult LVR_INVALID = new LinkValidationResult(1, true);
    private static final LinkValidationResult LVR_VALID = new LinkValidationResult(2, true);
    private String proxyHost;
    private int proxyPort;
    private String proxyUser;
    private String proxyPass;
    static /* synthetic */ Class class$org$apache$maven$linkcheck$validation$HTTPLinkValidator;

    public HTTPLinkValidator(String proxyHost, String proxyPort, String proxyUser, String proxyPass) {
        if (proxyHost == null) {
            LOG.info((Object)"maven-linkcheck-plugin: Not using a proxy");
            this.proxyHost = null;
        } else {
            this.proxyHost = proxyHost;
            this.proxyPort = Integer.parseInt(proxyPort);
            this.proxyUser = proxyUser;
            this.proxyPass = proxyPass;
            LOG.info((Object)("maven-linkcheck-plugin: Proxy Host:" + proxyHost));
            LOG.info((Object)("maven-linkcheck-plugin: Proxy Port:" + proxyPort));
            LOG.info((Object)("maven-linkcheck-plugin: Proxy User:" + proxyUser));
        }
    }

    public LinkValidationResult validateLink(LinkValidationItem lvi) {
        try {
            String link = lvi.getLink();
            LOG.debug((Object)("Checking web link:" + link));
            HttpClient cl = new HttpClient();
            HostConfiguration hc = new HostConfiguration();
            if (this.proxyHost != null) {
                hc.setProxy(this.proxyHost, this.proxyPort);
            }
            HttpState state = new HttpState();
            if (this.proxyUser != null && this.proxyPass != null) {
                state.setProxyCredentials(null, null, (Credentials)new UsernamePasswordCredentials(this.proxyUser, this.proxyPass));
            }
            cl.setHostConfiguration(hc);
            cl.setState(state);
            HeadMethod hm = this.checkLink(cl, link);
            StatusLine sl = hm.getStatusLine();
            if (sl == null) {
                LOG.info((Object)("Unknown error validating link : " + link));
                return LVR_VALID;
            }
            if (hm.getStatusCode() == 302) {
                Header locationHeader = hm.getResponseHeader("Location");
                if (locationHeader == null) {
                    LOG.info((Object)"Site sent redirect, but did not set Location header");
                } else {
                    String newLink = locationHeader.getValue();
                    LOG.debug((Object)("Following 1 redirect to " + newLink));
                    hm = this.checkLink(cl, newLink);
                }
            }
            if (hm.getStatusCode() == 200) {
                return LVR_VALID;
            }
            String msg = "Received: [" + hm.getStatusCode() + "] for " + link;
            LOG.info((Object)msg);
            System.out.println(msg);
            return LVR_INVALID;
        }
        catch (Exception e) {
            LOG.warn((Object)("Error accessing " + lvi.getLink()), (Throwable)e);
            e.printStackTrace();
            return LVR_INVALID;
        }
    }

    private HeadMethod checkLink(HttpClient cl, String link) {
        HeadMethod hm = new HeadMethod(link);
        try {
            LOG.info((Object)("Checking link " + link));
            hm.setFollowRedirects(true);
            cl.executeMethod((HttpMethod)hm);
            LOG.debug((Object)("Checked link " + link));
        }
        catch (Exception e) {
            LOG.warn((Object)("Error validating " + link + ": " + e));
            LOG.debug((Object)"Exception was", (Throwable)e);
        }
        return hm;
    }

    public Object getResourceKey(LinkValidationItem lvi) {
        String link = lvi.getLink();
        if (!link.startsWith("http://")) {
            return null;
        }
        int hashPos = link.indexOf("#");
        if (hashPos != -1) {
            link = link.substring(0, hashPos);
        }
        return link;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

