/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.DescribedDependency;
import org.apache.maven.MavenUtils;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;

public class DependencyDescriberBean {
    private List dependencies = new ArrayList();
    private Log log = LogFactory.getLog((Class)(class$org$apache$maven$DependencyDescriberBean == null ? (class$org$apache$maven$DependencyDescriberBean = DependencyDescriberBean.class$("org.apache.maven.DependencyDescriberBean")) : class$org$apache$maven$DependencyDescriberBean));
    private Project project;
    static /* synthetic */ Class class$org$apache$maven$DependencyDescriberBean;

    public List getDependencies() {
        return this.dependencies;
    }

    public void build(Project projectValue) {
        this.project = projectValue;
        Iterator iter = this.project.getDependencies().iterator();
        while (iter.hasNext()) {
            Dependency dependency = (Dependency)iter.next();
            DescribedDependency describedDependency = new DescribedDependency(dependency);
            this.dependencies.add(describedDependency);
            Project resolvedProject = this.resolveProject(dependency);
            if (resolvedProject == null) continue;
            this.log.debug((Object)("POM URL:" + resolvedProject.getUrl()));
            describedDependency.setUrl(resolvedProject.getUrl());
            describedDependency.setDescription(resolvedProject.getDescription());
        }
        Collections.sort(this.dependencies);
    }

    private Project resolveProject(Dependency dependency) {
        File projectFile = null;
        projectFile = "pom".equals(dependency.getType()) ? new File(this.project.getContext().getMavenRepoLocal(), dependency.getArtifact()) : new File(this.project.getContext().getMavenRepoLocal(), dependency.getArtifactDirectory() + "/poms/" + dependency.getArtifactId() + "-" + dependency.getVersion() + ".pom");
        try {
            if (projectFile.exists() && projectFile.canRead()) {
                return MavenUtils.getProject((File)projectFile, null, (boolean)false);
            }
            this.log.debug((Object)("Failed to read POM:" + projectFile));
            return null;
        }
        catch (Exception e) {
            this.log.debug((Object)("Failed to read POM:" + projectFile));
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

