/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.IAdaptiveRPGroup;
import me.adaptive.arp.api.IAppContextWebview;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.LoggingBridge;

public class AppContextWebviewBridge
implements IAppContextWebview {
    private IAdaptiveRPGroup apiGroup = IAdaptiveRPGroup.Kernel;
    private IAppContextWebview delegate;

    public AppContextWebviewBridge(IAppContextWebview delegate) {
        this.delegate = delegate;
    }

    public final IAppContextWebview getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IAppContextWebview delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addWebview(Object webView) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing addWebview...");
        }
        if (this.delegate != null) {
            this.delegate.addWebview(webView);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'addWebview' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'addWebview'.");
        }
    }

    @Override
    public void executeJavaScript(String javaScriptText) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing executeJavaScript...");
        }
        if (this.delegate != null) {
            this.delegate.executeJavaScript(javaScriptText);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'executeJavaScript' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'executeJavaScript'.");
        }
    }

    @Override
    public void executeJavaScript(String javaScriptText, Object webViewReference) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing executeJavaScript...");
        }
        if (this.delegate != null) {
            this.delegate.executeJavaScript(javaScriptText, webViewReference);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'executeJavaScript' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'executeJavaScript'.");
        }
    }

    @Override
    public Object getWebviewPrimary() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getWebviewPrimary...");
        }
        Object result = null;
        if (this.delegate != null) {
            result = this.delegate.getWebviewPrimary();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getWebviewPrimary' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getWebviewPrimary'.");
        }
        return result;
    }

    @Override
    public Object[] getWebviews() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getWebviews...");
        }
        Object[] result = null;
        if (this.delegate != null) {
            result = this.delegate.getWebviews();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getWebviews' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getWebviews'.");
        }
        return result;
    }

    @Override
    public void removeWebview(Object webView) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeWebview...");
        }
        if (this.delegate != null) {
            this.delegate.removeWebview(webView);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeWebview' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeWebview'.");
        }
    }
}

