/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseDataBridge;
import me.adaptive.arp.api.Database;
import me.adaptive.arp.api.DatabaseResultCallbackImpl;
import me.adaptive.arp.api.DatabaseTable;
import me.adaptive.arp.api.DatabaseTableResultCallbackImpl;
import me.adaptive.arp.api.IDatabase;
import me.adaptive.arp.api.IDatabaseResultCallback;
import me.adaptive.arp.api.IDatabaseTableResultCallback;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.LoggingBridge;

public class DatabaseBridge
extends BaseDataBridge
implements IDatabase,
APIBridge {
    private IDatabase delegate;

    public DatabaseBridge(IDatabase delegate) {
        this.delegate = delegate;
    }

    public final IDatabase getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IDatabase delegate) {
        this.delegate = delegate;
    }

    @Override
    public void createDatabase(Database database, IDatabaseResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing createDatabase...");
        }
        if (this.delegate != null) {
            this.delegate.createDatabase(database, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'createDatabase' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'createDatabase'.");
        }
    }

    @Override
    public void createTable(Database database, DatabaseTable databaseTable, IDatabaseTableResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing createTable...");
        }
        if (this.delegate != null) {
            this.delegate.createTable(database, databaseTable, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'createTable' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'createTable'.");
        }
    }

    @Override
    public void deleteDatabase(Database database, IDatabaseResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing deleteDatabase...");
        }
        if (this.delegate != null) {
            this.delegate.deleteDatabase(database, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'deleteDatabase' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'deleteDatabase'.");
        }
    }

    @Override
    public void deleteTable(Database database, DatabaseTable databaseTable, IDatabaseTableResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing deleteTable...");
        }
        if (this.delegate != null) {
            this.delegate.deleteTable(database, databaseTable, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'deleteTable' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'deleteTable'.");
        }
    }

    @Override
    public void executeSqlStatement(Database database, String statement, String[] replacements, IDatabaseTableResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing executeSqlStatement...");
        }
        if (this.delegate != null) {
            this.delegate.executeSqlStatement(database, statement, replacements, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'executeSqlStatement' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'executeSqlStatement'.");
        }
    }

    @Override
    public void executeSqlTransactions(Database database, String[] statements, boolean rollbackFlag, IDatabaseTableResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing executeSqlTransactions...");
        }
        if (this.delegate != null) {
            this.delegate.executeSqlTransactions(database, statements, rollbackFlag, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'executeSqlTransactions' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'executeSqlTransactions'.");
        }
    }

    @Override
    public boolean existsDatabase(Database database) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing existsDatabase...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.existsDatabase(database);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'existsDatabase' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'existsDatabase'.");
        }
        return result;
    }

    @Override
    public boolean existsTable(Database database, DatabaseTable databaseTable) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing existsTable...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.existsTable(database, databaseTable);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'existsTable' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'existsTable'.");
        }
        return result;
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "createDatabase": {
                Database database0 = (Database)this.getJSONParser().fromJson(request.getParameters()[0], Database.class);
                DatabaseResultCallbackImpl callback0 = new DatabaseResultCallbackImpl(request.getAsyncId());
                this.createDatabase(database0, callback0);
                break;
            }
            case "createTable": {
                Database database1 = (Database)this.getJSONParser().fromJson(request.getParameters()[0], Database.class);
                DatabaseTable databaseTable1 = (DatabaseTable)this.getJSONParser().fromJson(request.getParameters()[1], DatabaseTable.class);
                DatabaseTableResultCallbackImpl callback1 = new DatabaseTableResultCallbackImpl(request.getAsyncId());
                this.createTable(database1, databaseTable1, callback1);
                break;
            }
            case "deleteDatabase": {
                Database database2 = (Database)this.getJSONParser().fromJson(request.getParameters()[0], Database.class);
                DatabaseResultCallbackImpl callback2 = new DatabaseResultCallbackImpl(request.getAsyncId());
                this.deleteDatabase(database2, callback2);
                break;
            }
            case "deleteTable": {
                Database database3 = (Database)this.getJSONParser().fromJson(request.getParameters()[0], Database.class);
                DatabaseTable databaseTable3 = (DatabaseTable)this.getJSONParser().fromJson(request.getParameters()[1], DatabaseTable.class);
                DatabaseTableResultCallbackImpl callback3 = new DatabaseTableResultCallbackImpl(request.getAsyncId());
                this.deleteTable(database3, databaseTable3, callback3);
                break;
            }
            case "executeSqlStatement": {
                Database database4 = (Database)this.getJSONParser().fromJson(request.getParameters()[0], Database.class);
                String statement4 = (String)this.getJSONParser().fromJson(request.getParameters()[1], String.class);
                String[] replacements4 = (String[])this.getJSONParser().fromJson(request.getParameters()[2], String[].class);
                DatabaseTableResultCallbackImpl callback4 = new DatabaseTableResultCallbackImpl(request.getAsyncId());
                this.executeSqlStatement(database4, statement4, replacements4, callback4);
                break;
            }
            case "executeSqlTransactions": {
                Database database5 = (Database)this.getJSONParser().fromJson(request.getParameters()[0], Database.class);
                String[] statements5 = (String[])this.getJSONParser().fromJson(request.getParameters()[1], String[].class);
                boolean rollbackFlag5 = (Boolean)this.getJSONParser().fromJson(request.getParameters()[2], Boolean.TYPE);
                DatabaseTableResultCallbackImpl callback5 = new DatabaseTableResultCallbackImpl(request.getAsyncId());
                this.executeSqlTransactions(database5, statements5, rollbackFlag5, callback5);
                break;
            }
            case "existsDatabase": {
                Database database6 = (Database)this.getJSONParser().fromJson(request.getParameters()[0], Database.class);
                boolean response6 = this.existsDatabase(database6);
                responseJSON = "" + response6;
                break;
            }
            case "existsTable": {
                Database database7 = (Database)this.getJSONParser().fromJson(request.getParameters()[0], Database.class);
                DatabaseTable databaseTable7 = (DatabaseTable)this.getJSONParser().fromJson(request.getParameters()[1], DatabaseTable.class);
                boolean response7 = this.existsTable(database7, databaseTable7);
                responseJSON = "" + response7;
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "DatabaseBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.10.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

