/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseDataBridge;
import me.adaptive.arp.api.FileDescriptor;
import me.adaptive.arp.api.IFileSystem;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.LoggingBridge;

public class FileSystemBridge
extends BaseDataBridge
implements IFileSystem,
APIBridge {
    private IFileSystem delegate;

    public FileSystemBridge(IFileSystem delegate) {
        this.delegate = delegate;
    }

    public final IFileSystem getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IFileSystem delegate) {
        this.delegate = delegate;
    }

    @Override
    public FileDescriptor createFileDescriptor(FileDescriptor parent, String name) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing createFileDescriptor...");
        }
        FileDescriptor result = null;
        if (this.delegate != null) {
            result = this.delegate.createFileDescriptor(parent, name);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'createFileDescriptor' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'createFileDescriptor'.");
        }
        return result;
    }

    @Override
    public FileDescriptor getApplicationCacheFolder() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getApplicationCacheFolder...");
        }
        FileDescriptor result = null;
        if (this.delegate != null) {
            result = this.delegate.getApplicationCacheFolder();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getApplicationCacheFolder' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getApplicationCacheFolder'.");
        }
        return result;
    }

    @Override
    public FileDescriptor getApplicationCloudFolder() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getApplicationCloudFolder...");
        }
        FileDescriptor result = null;
        if (this.delegate != null) {
            result = this.delegate.getApplicationCloudFolder();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getApplicationCloudFolder' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getApplicationCloudFolder'.");
        }
        return result;
    }

    @Override
    public FileDescriptor getApplicationDocumentsFolder() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getApplicationDocumentsFolder...");
        }
        FileDescriptor result = null;
        if (this.delegate != null) {
            result = this.delegate.getApplicationDocumentsFolder();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getApplicationDocumentsFolder' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getApplicationDocumentsFolder'.");
        }
        return result;
    }

    @Override
    public FileDescriptor getApplicationFolder() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getApplicationFolder...");
        }
        FileDescriptor result = null;
        if (this.delegate != null) {
            result = this.delegate.getApplicationFolder();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getApplicationFolder' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getApplicationFolder'.");
        }
        return result;
    }

    @Override
    public FileDescriptor getApplicationProtectedFolder() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getApplicationProtectedFolder...");
        }
        FileDescriptor result = null;
        if (this.delegate != null) {
            result = this.delegate.getApplicationProtectedFolder();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getApplicationProtectedFolder' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getApplicationProtectedFolder'.");
        }
        return result;
    }

    @Override
    public char getSeparator() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getSeparator...");
        }
        char result = ' ';
        if (this.delegate != null) {
            result = this.delegate.getSeparator();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getSeparator' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getSeparator'.");
        }
        return result;
    }

    @Override
    public FileDescriptor getSystemExternalFolder() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getSystemExternalFolder...");
        }
        FileDescriptor result = null;
        if (this.delegate != null) {
            result = this.delegate.getSystemExternalFolder();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getSystemExternalFolder' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getSystemExternalFolder'.");
        }
        return result;
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "createFileDescriptor": {
                FileDescriptor parent0 = (FileDescriptor)this.getJSONParser().fromJson(request.getParameters()[0], FileDescriptor.class);
                String name0 = (String)this.getJSONParser().fromJson(request.getParameters()[1], String.class);
                FileDescriptor response0 = this.createFileDescriptor(parent0, name0);
                if (response0 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response0);
                break;
            }
            case "getApplicationCacheFolder": {
                FileDescriptor response1 = this.getApplicationCacheFolder();
                if (response1 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response1);
                break;
            }
            case "getApplicationCloudFolder": {
                FileDescriptor response2 = this.getApplicationCloudFolder();
                if (response2 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response2);
                break;
            }
            case "getApplicationDocumentsFolder": {
                FileDescriptor response3 = this.getApplicationDocumentsFolder();
                if (response3 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response3);
                break;
            }
            case "getApplicationFolder": {
                FileDescriptor response4 = this.getApplicationFolder();
                if (response4 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response4);
                break;
            }
            case "getApplicationProtectedFolder": {
                FileDescriptor response5 = this.getApplicationProtectedFolder();
                if (response5 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response5);
                break;
            }
            case "getSeparator": {
                char response6 = this.getSeparator();
                responseJSON = "" + response6;
                break;
            }
            case "getSystemExternalFolder": {
                FileDescriptor response7 = this.getSystemExternalFolder();
                if (response7 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response7);
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "FileSystemBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.10.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

