/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseCommunicationBridge;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.INetworkStatus;
import me.adaptive.arp.api.INetworkStatusListener;
import me.adaptive.arp.api.LoggingBridge;
import me.adaptive.arp.api.NetworkStatusListenerImpl;

public class NetworkStatusBridge
extends BaseCommunicationBridge
implements INetworkStatus,
APIBridge {
    private INetworkStatus delegate;

    public NetworkStatusBridge(INetworkStatus delegate) {
        this.delegate = delegate;
    }

    public final INetworkStatus getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(INetworkStatus delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addNetworkStatusListener(INetworkStatusListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing addNetworkStatusListener...");
        }
        if (this.delegate != null) {
            this.delegate.addNetworkStatusListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'addNetworkStatusListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'addNetworkStatusListener'.");
        }
    }

    @Override
    public void removeNetworkStatusListener(INetworkStatusListener listener) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeNetworkStatusListener...");
        }
        if (this.delegate != null) {
            this.delegate.removeNetworkStatusListener(listener);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeNetworkStatusListener' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeNetworkStatusListener'.");
        }
    }

    @Override
    public void removeNetworkStatusListeners() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing removeNetworkStatusListeners...");
        }
        if (this.delegate != null) {
            this.delegate.removeNetworkStatusListeners();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'removeNetworkStatusListeners' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'removeNetworkStatusListeners'.");
        }
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "addNetworkStatusListener": {
                NetworkStatusListenerImpl listener0 = new NetworkStatusListenerImpl(request.getAsyncId());
                this.addNetworkStatusListener(listener0);
                break;
            }
            case "removeNetworkStatusListener": {
                NetworkStatusListenerImpl listener1 = new NetworkStatusListenerImpl(request.getAsyncId());
                this.removeNetworkStatusListener(listener1);
                break;
            }
            case "removeNetworkStatusListeners": {
                this.removeNetworkStatusListeners();
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "NetworkStatusBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.10.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

