/*
 * Decompiled with CFR 0.152.
 */
package me.bazhenov.groovysh;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jline.TerminalFactory;
import me.bazhenov.groovysh.GroovyShellCommand;
import me.bazhenov.groovysh.SshTerminal;
import me.bazhenov.groovysh.thread.DefaultGroovyshThreadFactory;
import me.bazhenov.groovysh.thread.ServerSessionAwareThreadFactory;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.UserAuthNoneFactory;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.codehaus.groovy.tools.shell.Groovysh;

public class GroovyShellService {
    public static final AttributeStore.AttributeKey<Groovysh> SHELL_KEY = new AttributeStore.AttributeKey();
    private int port;
    private String host;
    private Map<String, Object> bindings;
    private PasswordAuthenticator passwordAuthenticator;
    private ServerSessionAwareThreadFactory threadFactory = new DefaultGroovyshThreadFactory();
    private List<String> defaultScripts = new ArrayList<String>();
    private SshServer sshd;

    public GroovyShellService() {
        this(6789);
    }

    public GroovyShellService(int port) {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Wrong port number");
        }
        this.port = port;
        TerminalFactory.registerFlavor((TerminalFactory.Flavor)TerminalFactory.Flavor.UNIX, SshTerminal.class);
    }

    public Map<String, Object> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, Object> bindings) {
        this.bindings = bindings;
    }

    public int getPort() {
        return this.port;
    }

    public void addDefaultScript(String script) {
        this.defaultScripts.add(script);
    }

    public List<String> getDefaultScripts() {
        return this.defaultScripts;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.passwordAuthenticator = passwordAuthenticator;
    }

    public void setThreadFactory(ServerSessionAwareThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public void setDefaultScripts(List<String> defaultScriptNames) {
        this.defaultScripts = defaultScriptNames;
    }

    public synchronized void start() throws IOException {
        this.sshd = this.buildSshServer();
        this.sshd.start();
    }

    protected SshServer buildSshServer() {
        SshServer sshd = SshServer.setUpDefaultServer();
        sshd.setPort(this.port);
        if (this.host != null) {
            sshd.setHost(this.host);
        }
        PropertyResolverUtils.updateProperty((PropertyResolver)sshd, (String)"idle-timeout", (long)TimeUnit.HOURS.toMillis(1L));
        sshd.addSessionListener(new SessionListener(){

            public void sessionCreated(Session session) {
            }

            public void sessionEvent(Session sesssion, SessionListener.Event event) {
            }

            public void sessionException(Session session, Throwable t) {
            }

            public void sessionClosed(Session session) {
                Groovysh shell = (Groovysh)session.getAttribute(SHELL_KEY);
                if (shell != null) {
                    shell.getRunner().setRunning(false);
                }
            }
        });
        sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(new File("host.key").toPath()));
        this.configureAuthentication(sshd);
        sshd.setShellFactory((Factory)new GroovyShellFactory());
        return sshd;
    }

    private void configureAuthentication(SshServer sshd) {
        UserAuthNoneFactory auth;
        if (this.passwordAuthenticator != null) {
            sshd.setPasswordAuthenticator(this.passwordAuthenticator);
            auth = new UserAuthPasswordFactory();
        } else {
            auth = new UserAuthNoneFactory();
        }
        sshd.setUserAuthFactories(Collections.singletonList(auth));
    }

    public synchronized void destroy() throws IOException {
        this.sshd.stop(true);
    }

    class GroovyShellFactory
    implements Factory<Command> {
        GroovyShellFactory() {
        }

        public Command create() {
            return new GroovyShellCommand(GroovyShellService.this.sshd, GroovyShellService.this.bindings, GroovyShellService.this.defaultScripts, GroovyShellService.this.threadFactory);
        }
    }
}

