/*
 * Decompiled with CFR 0.152.
 */
package me.geso.jdbcquerylog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import me.geso.jdbcquerylog.QueryLogDriver;
import me.geso.jdbctracer.PreparedStatementListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementLogger
implements PreparedStatementListener {
    private static final Pattern RE = Pattern.compile("(\\?)");
    private static final Logger log = LoggerFactory.getLogger(QueryLogDriver.class);

    public void trace(Connection connection, long elapsed, String query, List<Object> args) throws SQLException {
        if (!QueryLogDriver.isEnabled()) {
            return;
        }
        query = this.bind(query, args);
        if (QueryLogDriver.isCompact()) {
            query = this.compact(query);
        }
        QueryLogDriver.getPrintQuery().accept(connection, query);
        if (QueryLogDriver.isExplain()) {
            try (PreparedStatement preparedStatement = connection.prepareStatement("EXPLAIN " + query);
                 ResultSet resultSet = preparedStatement.executeQuery();){
                ResultSetMetaData metaData = resultSet.getMetaData();
                int columnCount = metaData.getColumnCount();
                String[] header = (String[])IntStream.rangeClosed(1, columnCount).mapToObj(i -> {
                    try {
                        return metaData.getColumnName(i);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }).toArray(String[]::new);
                ArrayList<String[]> rows = new ArrayList<String[]>();
                while (resultSet.next()) {
                    String[] row = (String[])IntStream.rangeClosed(1, columnCount).mapToObj(i -> {
                        try {
                            return resultSet.getString(i);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }).toArray(String[]::new);
                    rows.add(row);
                }
                QueryLogDriver.getPrintExplain().accept(connection, query, header, rows);
            }
        }
    }

    private String compact(String query) {
        return query.replaceAll("\\n", " ");
    }

    private String bind(String query, List<Object> binds) {
        int idx = 0;
        Matcher matcher = RE.matcher(query);
        boolean result = matcher.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                Object value;
                if ((value = binds.get(idx++)) instanceof Integer || value instanceof Long) {
                    matcher.appendReplacement(sb, String.valueOf(value));
                    continue;
                }
                matcher.appendReplacement(sb, '\"' + String.valueOf(value) + '\"');
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return query;
    }
}

