/*
 * Decompiled with CFR 0.152.
 */
package me.geso.jdbcquerylog;

import de.vandermeer.asciitable.v2.RenderedTable;
import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.V2_AsciiTableRenderer;
import de.vandermeer.asciitable.v2.render.V2_Width;
import de.vandermeer.asciitable.v2.render.WidthLongestLine;
import de.vandermeer.asciitable.v2.themes.V2_E_TableThemes;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import me.geso.jdbcquerylog.PreparedStatementLogger;
import me.geso.jdbctracer.PreparedStatementListener;
import me.geso.jdbctracer.TracerConnection;

public class QueryLogDriver
implements Driver {
    private static boolean enabled = true;
    private static boolean explain = false;
    private static boolean compact = true;
    private static BiConsumer<Connection, String> printQuery = (connection, query) -> System.err.println((String)query);
    private static PrintExplainCallback printExplain = (connection, query, header, rows) -> {
        V2_AsciiTable at = new V2_AsciiTable();
        at.addRule();
        at.addRow((Object[])header);
        at.addRule();
        rows.forEach(arg_0 -> ((V2_AsciiTable)at).addRow(arg_0));
        at.addRule();
        V2_AsciiTableRenderer rend = new V2_AsciiTableRenderer();
        rend.setTheme(V2_E_TableThemes.UTF_LIGHT.get());
        rend.setWidth((V2_Width)new WidthLongestLine());
        RenderedTable render = rend.render(at);
        System.err.println(render.toString());
    };

    public static void setEnabled(boolean enabled) {
        QueryLogDriver.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setExplain(boolean explain) {
        QueryLogDriver.explain = explain;
    }

    public static boolean isExplain() {
        return explain;
    }

    public static boolean isCompact() {
        return compact;
    }

    public static void setCompact(boolean compact) {
        QueryLogDriver.compact = compact;
    }

    public static void setPrintQuery(BiConsumer<Connection, String> printQuery) {
        QueryLogDriver.printQuery = printQuery;
    }

    public static BiConsumer<Connection, String> getPrintQuery() {
        return printQuery;
    }

    public static PrintExplainCallback getPrintExplain() {
        return printExplain;
    }

    public static void setPrintExplain(PrintExplainCallback printExplain) {
        QueryLogDriver.printExplain = printExplain;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String underlingUri = this.parseURL(url);
        if (underlingUri != null) {
            Driver underlyingDriver = this.getUnderlyingDriver(underlingUri);
            if (underlyingDriver == null) {
                return null;
            }
            Connection connection = Objects.requireNonNull(underlyingDriver.connect(underlingUri, info));
            return TracerConnection.newInstance((Connection)connection, (PreparedStatementListener)new PreparedStatementLogger(), null);
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        String underlingUri = this.parseURL(url);
        if (underlingUri != null) {
            return this.getUnderlyingDriver(underlingUri) != null;
        }
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Driver underlyingDriver = this.getUnderlyingDriver(url);
        if (underlyingDriver == null) {
            return new DriverPropertyInfo[0];
        }
        return underlyingDriver.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private String parseURL(String url) {
        if (url.startsWith("jdbc:querylog:")) {
            return "jdbc:" + url.substring("jdbc:querylog:".length());
        }
        return null;
    }

    private Driver getUnderlyingDriver(String underlingUri) throws SQLException {
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            Driver d = e.nextElement();
            if (!d.acceptsURL(underlingUri)) continue;
            return d;
        }
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new QueryLogDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Can't register jdbc-querylog driver!: " + e.getMessage());
        }
    }

    @FunctionalInterface
    public static interface PrintExplainCallback {
        public void accept(Connection var1, String var2, String[] var3, List<String[]> var4);
    }
}

