/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.utils;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import me.hsgamer.hscore.bukkit.utils.VersionUtils;
import me.hsgamer.hscore.common.CollectionUtils;
import me.hsgamer.hscore.common.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorUtils {
    private static final Pattern hybridColorPattern = Pattern.compile("(\\\\?)((\\S)\\(#([A-Fa-f\\d]{1,6}),([a-zA-Z\\d])\\))");
    private static final Map<Character, Supplier<Character>> colorMappers = Collections.singletonMap(Character.valueOf('u'), () -> Character.valueOf(ColorUtils.getRandomColor().getChar()));
    private static Predicate<CommandSender> hexSupportSenderCheck = sender -> VersionUtils.isAtLeast(16);
    private static BooleanSupplier hexSupportGlobalCheck = () -> VersionUtils.isAtLeast(16);

    private ColorUtils() {
    }

    @NotNull
    public static String replaceHybridColorCode(@Nullable CommandSender sender, char indicator, String input) {
        return StringUtils.replacePattern((String)input, (Pattern)hybridColorPattern, matcher -> {
            String matchedChar = matcher.group(3);
            if (matchedChar.indexOf(indicator) < 0) {
                return null;
            }
            boolean skip = matcher.group(1).equals("\\");
            if (skip) {
                return matcher.group(2);
            }
            if (sender != null ? hexSupportSenderCheck.test(sender) : hexSupportGlobalCheck.getAsBoolean()) {
                return indicator + "#" + matcher.group(4);
            }
            return indicator + matcher.group(5);
        });
    }

    @NotNull
    public static String colorize(@Nullable CommandSender sender, @NotNull String input) {
        char colorChar = '&';
        return ColorUtils.colorize(colorChar, ColorUtils.colorizeHex(colorChar, ColorUtils.replaceHybridColorCode(sender, colorChar, input)));
    }

    @NotNull
    public static String colorize(@NotNull String input) {
        return ColorUtils.colorize(null, input);
    }

    @NotNull
    public static String colorizeHex(char altColorChar, @NotNull String input) {
        return StringUtils.replaceHex((char)altColorChar, hex -> "\u00a7x\u00a7" + hex[0] + '\u00a7' + hex[1] + '\u00a7' + hex[2] + '\u00a7' + hex[3] + '\u00a7' + hex[4] + '\u00a7' + hex[5], (String)input);
    }

    @NotNull
    public static String colorize(char altColorChar, @NotNull String input) {
        return StringUtils.replaceChar((char)altColorChar, (char)'\u00a7', (String)input, colorMappers);
    }

    @NotNull
    public static ChatColor getRandomColor() {
        return Objects.requireNonNull((ChatColor)CollectionUtils.pickRandom((Object[])ChatColor.values(), ChatColor::isColor));
    }

    public static void setHexSupportSenderCheck(Predicate<CommandSender> hexSupportSenderCheck) {
        ColorUtils.hexSupportSenderCheck = hexSupportSenderCheck;
    }

    public static void setHexSupportGlobalCheck(BooleanSupplier hexSupportGlobalCheck) {
        ColorUtils.hexSupportGlobalCheck = hexSupportGlobalCheck;
    }
}

