/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.hsgamer.hscore.bukkit.utils.ColorUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public final class MessageUtils {
    private static final Map<Object, Supplier<String>> objectPrefixMap = new HashMap<Object, Supplier<String>>();
    private static Supplier<String> defaultPrefix = () -> "&7[&cHSCore&7] &f";

    private MessageUtils() {
    }

    public static void sendMessage(@NotNull CommandSender receiver, @NotNull String message) {
        MessageUtils.sendMessage(receiver, message, defaultPrefix);
    }

    public static void sendMessage(@NotNull CommandSender receiver, @NotNull String message, @NotNull String prefix) {
        if (!message.isEmpty()) {
            receiver.sendMessage(ColorUtils.colorize(receiver, prefix + message));
        }
    }

    public static void sendMessage(@NotNull CommandSender receiver, @NotNull String message, @NotNull Supplier<String> prefix) {
        MessageUtils.sendMessage(receiver, message, prefix.get());
    }

    public static void sendMessage(@NotNull CommandSender receiver, @NotNull String message, @NotNull Object object) {
        MessageUtils.sendMessage(receiver, message, MessageUtils.getPrefix(object).orElse(MessageUtils.getPrefix()));
    }

    public static void sendMessage(@NotNull Collection<CommandSender> receivers, @NotNull String message) {
        receivers.forEach(player -> MessageUtils.sendMessage(player, message));
    }

    public static void sendMessage(@NotNull Collection<CommandSender> receivers, @NotNull String message, @NotNull String prefix) {
        receivers.forEach(player -> MessageUtils.sendMessage(player, message, prefix));
    }

    public static void sendMessage(@NotNull Collection<CommandSender> receivers, @NotNull String message, @NotNull Supplier<String> prefix) {
        receivers.forEach(player -> MessageUtils.sendMessage(player, message, prefix));
    }

    public static void sendMessage(@NotNull Collection<CommandSender> receivers, @NotNull String message, @NotNull Object object) {
        receivers.forEach(player -> MessageUtils.sendMessage(player, message, object));
    }

    public static void sendMessage(@NotNull UUID uuid, @NotNull String message) {
        MessageUtils.sendMessage(uuid, message, defaultPrefix);
    }

    public static void sendMessage(@NotNull UUID uuid, @NotNull String message, @NotNull String prefix) {
        Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).ifPresent(player -> MessageUtils.sendMessage((CommandSender)player, message, prefix));
    }

    public static void sendMessage(@NotNull UUID uuid, @NotNull String message, @NotNull Supplier<String> prefix) {
        MessageUtils.sendMessage(uuid, message, prefix.get());
    }

    public static void sendMessage(@NotNull UUID uuid, @NotNull String message, @NotNull Object object) {
        MessageUtils.sendMessage(uuid, message, MessageUtils.getPrefix(object).orElse(MessageUtils.getPrefix()));
    }

    @NotNull
    public static String getPrefix() {
        return defaultPrefix.get();
    }

    public static void setPrefix(@NotNull Supplier<String> prefix) {
        defaultPrefix = prefix;
    }

    public static void setPrefix(@NotNull String prefix) {
        MessageUtils.setPrefix(() -> prefix);
    }

    public static Optional<String> getPrefix(@NotNull Object object) {
        return Optional.ofNullable(objectPrefixMap.get(object)).map(Supplier::get);
    }

    public static void setPrefix(@NotNull Object object, @NotNull Supplier<String> prefix) {
        objectPrefixMap.put(object, prefix);
    }

    public static void setPrefix(@NotNull Object object, @NotNull String prefix) {
        MessageUtils.setPrefix(object, () -> prefix);
    }

    public static void removePrefix(@NotNull Object object) {
        objectPrefixMap.remove(object);
    }
}

