/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.utils;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;

public final class PermissionUtils {
    private PermissionUtils() {
    }

    @NotNull
    public static Stream<String> getStringsFromPermissions(Permissible permissible, String prefix) {
        return permissible.getEffectivePermissions().parallelStream().map(PermissionAttachmentInfo::getPermission).filter(permission -> permission.startsWith(prefix)).map(permission -> permission.substring(prefix.length() + 1));
    }

    @NotNull
    public static Stream<Number> getNumbersFromPermissions(Permissible permissible, String prefix, Function<String, Stream<Number>> numberConverter) {
        return PermissionUtils.getStringsFromPermissions(permissible, prefix).flatMap(numberConverter);
    }

    @NotNull
    public static Stream<Number> getNumbersFromPermissions(Permissible permissible, String prefix) {
        return PermissionUtils.getNumbersFromPermissions(permissible, prefix, rawValue -> {
            try {
                return Stream.of(Integer.valueOf(Integer.parseInt(rawValue)));
            }
            catch (Exception e) {
                return Stream.empty();
            }
        });
    }

    public static boolean hasPermission(Player player, String permission) {
        if (permission.startsWith("-")) {
            return !player.hasPermission(permission.substring(1).trim());
        }
        return player.hasPermission(permission);
    }

    public static boolean hasAnyPermission(Player player, Collection<Permission> permissions) {
        for (Permission permission : permissions) {
            if (!player.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnyPermissionString(Player player, Collection<String> permissions) {
        for (String permission : permissions) {
            if (!player.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }
}

