/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.utils;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public final class VersionUtils {
    private static final int MAJOR_VERSION;
    private static final int MINOR_VERSION;

    private VersionUtils() {
    }

    public static int getMajorVersion() {
        return MAJOR_VERSION;
    }

    public static int getMinorVersion() {
        return MINOR_VERSION;
    }

    public static boolean isAtLeast(int version) {
        return MAJOR_VERSION >= version;
    }

    public static boolean isAtLeast(int majorVersion, int minorVersion) {
        return MAJOR_VERSION > majorVersion || MAJOR_VERSION == majorVersion && MINOR_VERSION >= minorVersion;
    }

    public static boolean isAt(int majorVersion) {
        return MAJOR_VERSION == majorVersion;
    }

    public static boolean isAt(int majorVersion, int minorVersion) {
        return MAJOR_VERSION == majorVersion && MINOR_VERSION == minorVersion;
    }

    static {
        Matcher matcher = Pattern.compile("MC: \\d\\.(\\d+)(\\.(\\d+))?").matcher(Bukkit.getVersion());
        if (matcher.find()) {
            MAJOR_VERSION = Integer.parseInt(matcher.group(1));
            MINOR_VERSION = Optional.ofNullable(matcher.group(3)).filter(s -> !s.isEmpty()).map(Integer::parseInt).orElse(0);
        } else {
            MAJOR_VERSION = -1;
            MINOR_VERSION = -1;
        }
    }
}

