/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.path.ConfigPath;
import me.hsgamer.hscore.logger.common.LogLevel;
import me.hsgamer.hscore.logger.common.Logger;
import me.hsgamer.hscore.logger.provider.LoggerProvider;

public final class PathLoader {
    private static final Logger LOGGER = LoggerProvider.getLogger(PathLoader.class);

    private PathLoader() {
    }

    public static List<Field> getPathFields(Config config) {
        return Arrays.stream(config.getClass().getDeclaredFields()).filter(field -> ConfigPath.class.isAssignableFrom(field.getType())).collect(Collectors.toList());
    }

    public static void loadPath(Config config) {
        PathLoader.getPathFields(config).forEach(field -> {
            boolean accessible = field.isAccessible();
            try {
                field.setAccessible(true);
                ((ConfigPath)field.get(config)).setConfig(config);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(LogLevel.WARN, (Throwable)e);
            }
            finally {
                field.setAccessible(accessible);
            }
        });
    }

    public static void reloadPath(Config config) {
        PathLoader.getPathFields(config).forEach(field -> {
            boolean accessible = field.isAccessible();
            try {
                field.setAccessible(true);
                ((ConfigPath)field.get(config)).reload();
            }
            catch (IllegalAccessException e) {
                LOGGER.log(LogLevel.WARN, (Throwable)e);
            }
            finally {
                field.setAccessible(accessible);
            }
        });
    }
}

