/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.path;

import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.PathString;
import me.hsgamer.hscore.config.path.ConfigPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AdvancedConfigPath<F, T>
implements ConfigPath<T> {
    private final PathString path;
    private final T def;
    private Config config;

    public AdvancedConfigPath(@NotNull PathString path, @Nullable T def) {
        this.path = path;
        this.def = def;
    }

    @Nullable
    public abstract F getFromConfig(@NotNull Config var1);

    @Nullable
    public abstract T convert(@NotNull F var1);

    @Nullable
    public abstract F convertToRaw(@NotNull T var1);

    @Override
    public T getValue() {
        return this.config == null ? this.def : this.getValue(this.config);
    }

    @Override
    public void setValue(@Nullable T value) {
        if (this.config != null) {
            this.setValue(value, this.config);
        }
    }

    @Override
    public T getValue(@NotNull Config config) {
        F rawValue = this.getFromConfig(config);
        if (rawValue == null) {
            return this.def;
        }
        T value = this.convert(rawValue);
        return value != null ? value : this.def;
    }

    @Override
    public void setValue(@Nullable T value, @NotNull Config config) {
        config.set(this.path, value != null ? this.convertToRaw(value) : null);
    }

    @Override
    @NotNull
    public PathString getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(@NotNull Config config) {
        this.config = config;
        this.migrateConfig(config);
    }

    @Override
    public void migrateConfig(@NotNull Config config) {
        config.setIfAbsent(this.path, this.def != null ? this.convertToRaw(this.def) : null);
    }
}

