/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.path;

import java.util.function.Function;
import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.PathString;
import me.hsgamer.hscore.config.path.ConfigPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseConfigPath<T>
implements ConfigPath<T> {
    private final Function<Object, T> typeConverter;
    private final PathString path;
    private final T def;
    private Config config;

    public BaseConfigPath(@NotNull PathString path, @Nullable T def, @NotNull Function<Object, T> typeConverter) {
        this.path = path;
        this.def = def;
        this.typeConverter = typeConverter;
    }

    @Override
    public T getValue() {
        return this.config == null ? this.def : this.getValue(this.config);
    }

    @Override
    public void setValue(@Nullable T value) {
        if (this.config != null) {
            this.setValue(value, this.config);
        }
    }

    @Override
    public T getValue(@NotNull Config config) {
        Object rawValue = config.getNormalized(this.path, this.def);
        return rawValue == null ? this.def : this.typeConverter.apply(rawValue);
    }

    @Override
    public void setValue(@Nullable T value, @NotNull Config config) {
        config.set(this.path, value);
    }

    @Override
    @NotNull
    public PathString getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(@NotNull Config config) {
        this.config = config;
        this.migrateConfig(config);
    }

    @Override
    public void migrateConfig(@NotNull Config config) {
        config.setIfAbsent(this.path, this.def);
    }
}

