/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.path;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import me.hsgamer.hscore.config.CommentType;
import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.PathString;
import me.hsgamer.hscore.config.path.ConfigPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentablePath<T>
implements ConfigPath<T> {
    private final ConfigPath<T> originalPath;
    private final EnumMap<CommentType, List<String>> defaultCommentMap = new EnumMap(CommentType.class);

    public CommentablePath(@NotNull ConfigPath<T> originalPath, @NotNull List<String> blockComments, @NotNull List<String> sideComments) {
        this.originalPath = originalPath;
        this.defaultCommentMap.put(CommentType.BLOCK, blockComments);
        this.defaultCommentMap.put(CommentType.SIDE, sideComments);
    }

    public CommentablePath(@NotNull ConfigPath<T> originalPath, String ... blockComments) {
        this(originalPath, Arrays.asList(blockComments), Collections.emptyList());
    }

    @Override
    public T getValue() {
        return this.originalPath.getValue();
    }

    @Override
    public void setValue(@Nullable T value) {
        this.originalPath.setValue(value);
    }

    @Override
    public T getValue(@NotNull Config config) {
        return this.originalPath.getValue(config);
    }

    @Override
    public void setValue(@Nullable T value, @NotNull Config config) {
        this.originalPath.setValue(value, config);
    }

    @Override
    @NotNull
    public PathString getPath() {
        return this.originalPath.getPath();
    }

    @Override
    @Nullable
    public Config getConfig() {
        return this.originalPath.getConfig();
    }

    @Override
    public void setConfig(@NotNull Config config) {
        this.originalPath.setConfig(config);
        this.defaultCommentMap.forEach((type, s) -> {
            if (config.getComment(this.getPath(), type).isEmpty()) {
                config.setComment(this.getPath(), s, type);
            }
        });
    }

    @Override
    public void migrateConfig(@NotNull Config config) {
        this.originalPath.migrateConfig(config);
    }

    @Nullable
    public List<String> getComment() {
        return this.getComment(CommentType.BLOCK);
    }

    public void setComment(@Nullable List<String> comment) {
        this.setComment(CommentType.BLOCK, comment);
    }

    @Nullable
    public List<String> getComment(@NotNull CommentType commentType) {
        return Optional.ofNullable(this.getConfig()).map(config -> config.getComment(this.getPath(), commentType)).filter(list -> !list.isEmpty()).orElseGet(() -> this.defaultCommentMap.get(commentType));
    }

    public void setComment(@NotNull CommentType commentType, @Nullable List<String> comment) {
        Optional.ofNullable(this.getConfig()).ifPresent(config -> config.setComment(this.getPath(), comment, commentType));
    }
}

