/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.config.path;

import me.hsgamer.hscore.common.CachedValue;
import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.PathString;
import me.hsgamer.hscore.config.path.ConfigPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StickyConfigPath<T>
extends CachedValue<T>
implements ConfigPath<T> {
    private final ConfigPath<T> originalPath;

    public StickyConfigPath(ConfigPath<T> originalPath) {
        this.originalPath = originalPath;
    }

    public T generate() {
        return this.originalPath.getValue();
    }

    @Override
    public void reload() {
        this.originalPath.reload();
        this.clearCache();
    }

    @Override
    public void setValue(@Nullable T value) {
        this.originalPath.setValue(value);
        this.clearCache();
    }

    @Override
    public T getValue(@NotNull Config config) {
        return this.originalPath.getValue(config);
    }

    @Override
    public void setValue(@Nullable T value, @NotNull Config config) {
        this.originalPath.setValue(value, config);
    }

    @Override
    @NotNull
    public PathString getPath() {
        return this.originalPath.getPath();
    }

    @Override
    @Nullable
    public Config getConfig() {
        return this.originalPath.getConfig();
    }

    @Override
    public void setConfig(@NotNull Config config) {
        this.originalPath.setConfig(config);
        this.clearCache();
    }
}

