/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.database.driver.mysql;

import me.hsgamer.hscore.database.Driver;
import me.hsgamer.hscore.database.Setting;

public class MySqlDriver
implements Driver {
    public Class<? extends java.sql.Driver> getDriverClass() {
        try {
            return com.mysql.cj.jdbc.Driver.class;
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError e) {
            try {
                return Class.forName("com.mysql.jdbc.Driver").asSubclass(java.sql.Driver.class);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Cannot find the driver class", ex);
            }
        }
    }

    public String convertURL(Setting setting) {
        return "jdbc:mysql://" + setting.getNormalizedHost() + '/' + setting.getDatabaseName() + Driver.createPropertyString((Setting)setting);
    }

    public void applyDefaultSetting(Setting setting) {
        setting.setPort("3306").setUsername("root");
    }
}

