/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.web;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import org.jetbrains.annotations.NotNull;

public final class WebUtils {
    private WebUtils() {
    }

    @NotNull
    public static URLConnection createConnection(@NotNull String address) throws IOException {
        return new URL(address).openConnection();
    }

    @NotNull
    public static HttpURLConnection createHttpConnection(@NotNull String address) throws IOException {
        URLConnection connection = WebUtils.createConnection(address);
        if (connection instanceof HttpURLConnection) {
            return (HttpURLConnection)connection;
        }
        connection.setConnectTimeout(5);
        throw new IOException("The URL is not a HTTP URL");
    }

    @NotNull
    public static HttpsURLConnection createHttpsConnection(@NotNull String address) throws IOException {
        URLConnection connection = WebUtils.createConnection(address);
        if (connection instanceof HttpsURLConnection) {
            return (HttpsURLConnection)connection;
        }
        connection.setConnectTimeout(5);
        throw new IOException("The URL is not a HTTPS URL");
    }
}

