/*
 * Decompiled with CFR 0.152.
 */
package me.jeffshaw.digitalocean;

import java.time.Instant;
import me.jeffshaw.digitalocean.Action;
import me.jeffshaw.digitalocean.BackupWindow;
import me.jeffshaw.digitalocean.DigitalOceanClient;
import me.jeffshaw.digitalocean.Droplet;
import me.jeffshaw.digitalocean.DropletCreation;
import me.jeffshaw.digitalocean.DropletDeletion;
import me.jeffshaw.digitalocean.Image;
import me.jeffshaw.digitalocean.Kernel;
import me.jeffshaw.digitalocean.Listable;
import me.jeffshaw.digitalocean.Listable$;
import me.jeffshaw.digitalocean.Listable$class;
import me.jeffshaw.digitalocean.Networks;
import me.jeffshaw.digitalocean.Path;
import me.jeffshaw.digitalocean.Path$class;
import me.jeffshaw.digitalocean.Region;
import me.jeffshaw.digitalocean.RegionEnum;
import me.jeffshaw.digitalocean.Size;
import me.jeffshaw.digitalocean.SizeEnum;
import me.jeffshaw.digitalocean.SshKey;
import me.jeffshaw.digitalocean.Status;
import me.jeffshaw.digitalocean.responses.package;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.package$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple18;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.BigInt;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Droplet$
implements Path,
Listable<Droplet, package.Droplets>,
Serializable {
    public static final Droplet$ MODULE$;
    private final Seq<String> path;
    private final Map<String, Seq<String>> queryParameters;

    static {
        new Droplet$();
    }

    @Override
    public Future<Iterator<Droplet>> list(DigitalOceanClient client, ExecutionContext ec, Manifest<package.Droplets> mf) {
        return Listable$class.list(this, client, ec, mf);
    }

    @Override
    public Future<BigInt> size(DigitalOceanClient client, ExecutionContext ec, Manifest<package.Droplets> mf) {
        return Listable$class.size(this, client, ec, mf);
    }

    @Override
    public Map<String, Seq<String>> queryParameters() {
        return this.queryParameters;
    }

    @Override
    public void me$jeffshaw$digitalocean$Path$_setter_$queryParameters_$eq(Map x$1) {
        this.queryParameters = x$1;
    }

    @Override
    public Seq<String> path() {
        return this.path;
    }

    public Future<Droplet> apply(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        Seq path = (Seq)this.path().$colon$plus((Object)id.toString(), Seq$.MODULE$.canBuildFrom());
        return client.get((Seq<String>)path, client.get$default$2(), ManifestFactory$.MODULE$.classType(package.Droplet.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Droplet apply(package.Droplet response) {
                return response.droplet();
            }
        }, ec);
    }

    public Future<Object> exists(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        Seq path = (Seq)this.path().$colon$plus((Object)id.toString(), Seq$.MODULE$.canBuildFrom());
        return client.exists((Seq<String>)path, client.exists$default$2());
    }

    public Future<Object> isDeleted(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return this.exists(id, client, ec).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean exists2) {
                return !exists2;
            }
        }, ec);
    }

    public Future<DropletDeletion> delete(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        Seq path = (Seq)this.path().$colon$plus((Object)id.toString(), Seq$.MODULE$.canBuildFrom());
        return client.delete((Seq<String>)path, client.delete$default$2()).map((Function1)new Serializable(id){
            public static final long serialVersionUID = 0L;
            private final BigInt id$1;

            public final DropletDeletion apply(BoxedUnit _) {
                return new DropletDeletion(this.id$1);
            }
            {
                this.id$1 = id$1;
            }
        }, ec);
    }

    public Future<BoxedUnit> delete(String tag, DigitalOceanClient client, ExecutionContext ec) {
        return client.delete(this.path(), (Map<String, Seq<String>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"tag_name"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tag})))}))));
    }

    public Future<Iterator<Kernel>> kernels(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return Listable$.MODULE$.listGet((Seq<String>)((Seq)this.path().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{id.toString(), "kernels"})), Seq$.MODULE$.canBuildFrom())), Listable$.MODULE$.listGet$default$2(), client, ec, ManifestFactory$.MODULE$.classType(package.Kernels.class));
    }

    public Future<Iterator<Image>> snapshots(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return Listable$.MODULE$.listGet((Seq<String>)((Seq)this.path().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{id.toString(), "snapshots"})), Seq$.MODULE$.canBuildFrom())), Listable$.MODULE$.listGet$default$2(), client, ec, ManifestFactory$.MODULE$.classType(package.Snapshots.class));
    }

    public Future<Iterator<Image>> backups(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return Listable$.MODULE$.listGet((Seq<String>)((Seq)this.path().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{id.toString(), "backups"})), Seq$.MODULE$.canBuildFrom())), Listable$.MODULE$.listGet$default$2(), client, ec, ManifestFactory$.MODULE$.classType(package.Backups.class));
    }

    public Future<Action> action(BigInt id, BigInt actionId, DigitalOceanClient client, ExecutionContext ec) {
        Seq path = (Seq)this.path().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{id.toString(), "actions", actionId.toString()})), Seq$.MODULE$.canBuildFrom());
        return client.get((Seq<String>)path, client.get$default$2(), ManifestFactory$.MODULE$.classType(package.Action.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Action apply(package.Action response) {
                return response.action();
            }
        }, ec);
    }

    public Future<Iterator<Action>> actions(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return Listable$.MODULE$.listGet((Seq<String>)((Seq)this.path().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{id.toString(), "actions"})), Seq$.MODULE$.canBuildFrom())), (Map<String, Seq<String>>)Predef$.MODULE$.Map().empty(), client, ec, ManifestFactory$.MODULE$.classType(package.Actions.class));
    }

    private Future<Action> performAction(BigInt id, String action2, JsonAST.JObject argument, DigitalOceanClient client, ExecutionContext ec) {
        Seq path = (Seq)this.path().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{id.toString(), "actions"})), Seq$.MODULE$.canBuildFrom());
        return client.post((Seq<String>)path, (JsonAST.JValue)JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"type"), (Object)action2), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(argument), client.post$default$3(), ManifestFactory$.MODULE$.classType(package.Action.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Action apply(package.Action x$1) {
                return x$1.action();
            }
        }, ec);
    }

    private JsonAST.JObject performAction$default$3() {
        return package$.MODULE$.JObject().apply((List)Nil$.MODULE$);
    }

    private Future<Iterator<Action>> performTaggedActions(String tag, String action2, JsonAST.JObject argument, DigitalOceanClient client, ExecutionContext ec) {
        return Listable$.MODULE$.listPost((Seq<String>)((Seq)this.path().$colon$plus((Object)"actions", Seq$.MODULE$.canBuildFrom())), (JsonAST.JValue)JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"type"), (Object)action2), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(argument), (Map<String, Seq<String>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"tag_name"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tag})))}))), client, ec, ManifestFactory$.MODULE$.classType(package.Actions.class));
    }

    private JsonAST.JObject performTaggedActions$default$3() {
        return package$.MODULE$.JObject().apply((List)Nil$.MODULE$);
    }

    public Future<Action> reboot(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "reboot", this.performAction$default$3(), client, ec);
    }

    public Future<Iterator<Action>> reboot(String tag, DigitalOceanClient client, ExecutionContext ec) {
        return this.performTaggedActions(tag, "reboot", this.performTaggedActions$default$3(), client, ec);
    }

    public Future<Action> powerCycle(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "power_cycle", this.performAction$default$3(), client, ec);
    }

    public Future<Iterator<Action>> powerCycle(String tag, DigitalOceanClient client, ExecutionContext ec) {
        return this.performTaggedActions(tag, "power_cycle", this.performTaggedActions$default$3(), client, ec);
    }

    public Future<Action> shutdown(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "shutdown", this.performAction$default$3(), client, ec);
    }

    public Future<Iterator<Action>> shutdown(String tag, DigitalOceanClient client, ExecutionContext ec) {
        return this.performTaggedActions(tag, "shutdown", this.performTaggedActions$default$3(), client, ec);
    }

    public Future<Action> powerOff(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "power_off", this.performAction$default$3(), client, ec);
    }

    public Future<Iterator<Action>> powerOff(String tag, DigitalOceanClient client, ExecutionContext ec) {
        return this.performTaggedActions(tag, "power_off", this.performTaggedActions$default$3(), client, ec);
    }

    public Future<Action> powerOn(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "power_on", this.performAction$default$3(), client, ec);
    }

    public Future<Iterator<Action>> powerOn(String tag, DigitalOceanClient client, ExecutionContext ec) {
        return this.performTaggedActions(tag, "power_on", this.performTaggedActions$default$3(), client, ec);
    }

    public Future<Action> passwordReset(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "password_reset", this.performAction$default$3(), client, ec);
    }

    public Future<Action> resize(BigInt id, SizeEnum size2, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "resize", JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"size"), (Object)size2.slug()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }), client, ec);
    }

    public Future<Action> restore(BigInt id, Image image, DigitalOceanClient client, ExecutionContext ec) {
        return this.restore(id, image.id(), client, ec);
    }

    public Future<Action> restore(BigInt id, BigInt imageId, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "restore", JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"image"), (Object)imageId), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(BigInt x) {
                return JsonDSL$.MODULE$.bigint2jvalue(x);
            }
        }), client, ec);
    }

    public Future<Action> rebuild(BigInt id, Image image, DigitalOceanClient client, ExecutionContext ec) {
        return this.rebuild(id, image.id(), client, ec);
    }

    public Future<Action> rebuild(BigInt id, BigInt imageId, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "rebuild", JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"image"), (Object)imageId), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(BigInt x) {
                return JsonDSL$.MODULE$.bigint2jvalue(x);
            }
        }), client, ec);
    }

    public Future<Action> rebuild(BigInt id, String imageSlug, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "rebuid", JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"image"), (Object)imageSlug), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }), client, ec);
    }

    public Future<Action> rename(BigInt id, String name, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "rename", JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)name), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }), client, ec);
    }

    public Future<Action> changeKernel(BigInt id, Kernel kernel, DigitalOceanClient client, ExecutionContext ec) {
        return this.changeKernel(id, kernel.id(), client, ec);
    }

    public Future<Action> changeKernel(BigInt id, BigInt kernelId, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "change_kernel", JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"kernel"), (Object)kernelId), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(BigInt x) {
                return JsonDSL$.MODULE$.bigint2jvalue(x);
            }
        }), client, ec);
    }

    public Future<Action> enableIPv6(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "enable_ipv6", this.performAction$default$3(), client, ec);
    }

    public Future<Iterator<Action>> enableIPv6(String tag, DigitalOceanClient client, ExecutionContext ec) {
        return this.performTaggedActions(tag, "enable_ipv6", this.performTaggedActions$default$3(), client, ec);
    }

    public Future<Action> disableBackups(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "disable_backups", this.performAction$default$3(), client, ec);
    }

    public Future<Iterator<Action>> disableBackups(String tag, DigitalOceanClient client, ExecutionContext ec) {
        return this.performTaggedActions(tag, "disable_backups", this.performTaggedActions$default$3(), client, ec);
    }

    public Future<Action> enablePrivateNetworking(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "enable_private_networking", this.performAction$default$3(), client, ec);
    }

    public Future<Iterator<Action>> enablePrivateNetworking(String tag, DigitalOceanClient client, ExecutionContext ec) {
        return this.performTaggedActions(tag, "enable_private_networking", this.performTaggedActions$default$3(), client, ec);
    }

    public Future<Action> snapshot(BigInt id, Option<String> name, DigitalOceanClient client, ExecutionContext ec) {
        return this.performAction(id, "snapshot", JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), name), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(Option<String> opt) {
                return JsonDSL$.MODULE$.option2jvalue(opt, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(String x) {
                        return JsonDSL$.MODULE$.string2jvalue(x);
                    }
                });
            }
        }), client, ec);
    }

    public Future<Iterator<Action>> snapshot(String tag, Option<String> name, DigitalOceanClient client, ExecutionContext ec) {
        return this.performTaggedActions(tag, "snapshot", JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), name), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(Option<String> opt) {
                return JsonDSL$.MODULE$.option2jvalue(opt, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(String x) {
                        return JsonDSL$.MODULE$.string2jvalue(x);
                    }
                });
            }
        }), client, ec);
    }

    public Future<Iterator<Droplet>> neighbors(BigInt id, DigitalOceanClient client, ExecutionContext ec) {
        return Listable$.MODULE$.listGet((Seq<String>)((Seq)this.path().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{id.toString(), "neighbors"})), Seq$.MODULE$.canBuildFrom())), Listable$.MODULE$.listGet$default$2(), client, ec, ManifestFactory$.MODULE$.classType(package.Droplets.class));
    }

    public Future<DropletCreation> create(String name, RegionEnum region, SizeEnum size2, Image image, Seq<SshKey> sshKeys, boolean backups, boolean ipv6, boolean privateNetworking, Option<String> userData, DigitalOceanClient client, ExecutionContext ec) {
        return this.create(name, region, size2, image.id(), sshKeys, backups, ipv6, privateNetworking, userData, client, ec);
    }

    public Future<DropletCreation> create(String name, RegionEnum region, SizeEnum size2, BigInt image, Seq<SshKey> sshKeys, boolean backups, boolean ipv6, boolean privateNetworking, Option<String> userData, DigitalOceanClient client, ExecutionContext ec) {
        Tuple2 imagePart = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"image"), (Object)image);
        return this.createAux(name, region, size2, (JsonAST.JValue)JsonDSL$.MODULE$.pair2jvalue(imagePart, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(BigInt x) {
                return JsonDSL$.MODULE$.bigint2jvalue(x);
            }
        }), sshKeys, backups, ipv6, privateNetworking, userData, client, ec);
    }

    public Future<DropletCreation> create(String name, RegionEnum region, SizeEnum size2, String image, Seq<SshKey> sshKeys, boolean backups, boolean ipv6, boolean privateNetworking, Option<String> userData, DigitalOceanClient client, ExecutionContext ec) {
        Tuple2 imagePart = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"image"), (Object)image);
        return this.createAux(name, region, size2, (JsonAST.JValue)JsonDSL$.MODULE$.pair2jvalue(imagePart, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }), sshKeys, backups, ipv6, privateNetworking, userData, client, ec);
    }

    private Future<DropletCreation> createAux(String name, RegionEnum region, SizeEnum size2, JsonAST.JValue imagePart, Seq<SshKey> sshKeys, boolean backups, boolean ipv6, boolean privateNetworking, Option<String> userData, DigitalOceanClient client, ExecutionContext ec) {
        JsonAST.JObject nonImageParts = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)name), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"region"), (Object)region.slug()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        })).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"size"), (Object)size2.slug()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ssh_keys"), sshKeys.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BigInt apply(SshKey x$2) {
                return x$2.id();
            }
        }, Seq$.MODULE$.canBuildFrom())), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JArray apply(Traversable<BigInt> s) {
                return JsonDSL$.MODULE$.seq2jvalue(s, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(BigInt x) {
                        return JsonDSL$.MODULE$.bigint2jvalue(x);
                    }
                });
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"backups"), (Object)BoxesRunTime.boxToBoolean((boolean)backups)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ipv6"), (Object)BoxesRunTime.boxToBoolean((boolean)ipv6)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"private_networking"), (Object)BoxesRunTime.boxToBoolean((boolean)privateNetworking)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(boolean x) {
                return JsonDSL$.MODULE$.boolean2jvalue(x);
            }
        }))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"user_data"), userData), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(Option<String> opt) {
                return JsonDSL$.MODULE$.option2jvalue(opt, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(String x) {
                        return JsonDSL$.MODULE$.string2jvalue(x);
                    }
                });
            }
        }));
        JsonAST.JValue requestJson = JsonAST.JValue$.MODULE$.j2m((JsonAST.JValue)nonImageParts).merge(imagePart, JsonAST.JValue$.MODULE$.jjj());
        return client.post(this.path(), requestJson, client.post$default$3(), ManifestFactory$.MODULE$.classType(package.DropletCreation.class)).flatMap((Function1)new Serializable(client, ec){
            public static final long serialVersionUID = 0L;
            private final DigitalOceanClient client$1;
            private final ExecutionContext ec$1;

            public final Future<DropletCreation> apply(package.DropletCreation response) {
                return response.toDropletCreation(this.client$1, this.ec$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DropletCreation apply(DropletCreation droplet) {
                        return droplet;
                    }
                }, this.ec$1);
            }
            {
                this.client$1 = client$1;
                this.ec$1 = ec$1;
            }
        }, ec);
    }

    public Droplet apply(BigInt id, String name, BigInt memory, BigInt vcpus, BigInt disk, Region region, Image image, Kernel kernel, Size size2, boolean locked, Instant createdAt, Status status, Networks networks, Seq<BigInt> backupIds, Seq<BigInt> snapshotIds, Seq<String> features, BackupWindow nextBackupWindow, Seq<String> tags) {
        return new Droplet(id, name, memory, vcpus, disk, region, image, kernel, size2, locked, createdAt, status, networks, backupIds, snapshotIds, features, nextBackupWindow, tags);
    }

    public Option<Tuple18<BigInt, String, BigInt, BigInt, BigInt, Region, Image, Kernel, Size, Object, Instant, Status, Networks, Seq<BigInt>, Seq<BigInt>, Seq<String>, BackupWindow, Seq<String>>> unapply(Droplet x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple18((Object)x$0.id(), (Object)x$0.name(), (Object)x$0.memory(), (Object)x$0.vcpus(), (Object)x$0.disk(), (Object)x$0.region(), (Object)x$0.image(), (Object)x$0.kernel(), (Object)x$0.size(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.locked()), (Object)x$0.createdAt(), (Object)x$0.status(), (Object)x$0.networks(), x$0.backupIds(), x$0.snapshotIds(), x$0.features(), (Object)x$0.nextBackupWindow(), x$0.tags()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Droplet$() {
        MODULE$ = this;
        Path$class.$init$(this);
        Listable$class.$init$(this);
        this.path = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"droplets"}));
    }
}

