/*
 * Decompiled with CFR 0.152.
 */
package me.jeffshaw.digitalocean.dns;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import me.jeffshaw.digitalocean.DigitalOceanClient;
import me.jeffshaw.digitalocean.Listable;
import me.jeffshaw.digitalocean.Listable$class;
import me.jeffshaw.digitalocean.Path;
import me.jeffshaw.digitalocean.Path$class;
import me.jeffshaw.digitalocean.dns.Domain;
import me.jeffshaw.digitalocean.dns.Domain$CreateRecord$;
import me.jeffshaw.digitalocean.dns.DomainRecord;
import me.jeffshaw.digitalocean.package$;
import me.jeffshaw.digitalocean.responses.package;
import org.json4s.Extraction$;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.BigInt;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Domain$
implements Path,
Listable<Domain, package.Domains>,
Serializable {
    public static final Domain$ MODULE$;
    private final Seq<String> path;
    private final Map<String, Seq<String>> queryParameters;

    static {
        new Domain$();
    }

    @Override
    public Future<Iterator<Domain>> list(DigitalOceanClient client, ExecutionContext ec, Manifest<package.Domains> mf) {
        return Listable$class.list(this, client, ec, mf);
    }

    @Override
    public Future<BigInt> size(DigitalOceanClient client, ExecutionContext ec, Manifest<package.Domains> mf) {
        return Listable$class.size(this, client, ec, mf);
    }

    @Override
    public Map<String, Seq<String>> queryParameters() {
        return this.queryParameters;
    }

    @Override
    public void me$jeffshaw$digitalocean$Path$_setter_$queryParameters_$eq(Map x$1) {
        this.queryParameters = x$1;
    }

    @Override
    public Seq<String> path() {
        return this.path;
    }

    public Future<Domain> apply(String name, DigitalOceanClient client, ExecutionContext ec) {
        Seq getPath = (Seq)this.path().$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom());
        return client.get((Seq<String>)getPath, client.get$default$2(), ManifestFactory$.MODULE$.classType(package.Domain.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Domain apply(package.Domain x$3) {
                return x$3.domain();
            }
        }, ec);
    }

    public Future<Domain> create(String name, String ipAddress, DigitalOceanClient client, ExecutionContext ec) {
        return this.create(name, InetAddress.getByName(ipAddress), client, ec);
    }

    public Future<Domain> create(String name, InetAddress ipAddress, DigitalOceanClient client, ExecutionContext ec) {
        JsonAST.JObject postBody = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)name), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ip_address"), (Object)ipAddress.getHostAddress()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(String x) {
                return JsonDSL$.MODULE$.string2jvalue(x);
            }
        });
        return client.post(this.path(), (JsonAST.JValue)postBody, client.post$default$3(), ManifestFactory$.MODULE$.classType(package.Domain.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Domain apply(package.Domain x$4) {
                return x$4.domain();
            }
        }, ec);
    }

    public Future<BoxedUnit> delete(String name, DigitalOceanClient client, ExecutionContext ec) {
        Seq deletePath = (Seq)this.path().$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom());
        return client.delete((Seq<String>)deletePath, client.delete$default$2());
    }

    public Future<BoxedUnit> deleteRecord(String name, BigInt recordId, DigitalOceanClient client, ExecutionContext ec) {
        Seq deletePath = (Seq)this.path().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name, recordId.toString()})), Seq$.MODULE$.canBuildFrom());
        return client.delete((Seq<String>)deletePath, client.delete$default$2());
    }

    private Future<DomainRecord> createRecord(String domainName, Domain.CreateRecord record, DigitalOceanClient client, ExecutionContext ec) {
        Seq postPath = (Seq)this.path().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{domainName, "records"})), Seq$.MODULE$.canBuildFrom());
        JsonAST.JValue postBody = Extraction$.MODULE$.decompose((Object)record, package$.MODULE$.formats());
        return client.post((Seq<String>)postPath, postBody, client.post$default$3(), ManifestFactory$.MODULE$.classType(package.DomainRecord.class)).map((Function1)new Serializable(domainName){
            public static final long serialVersionUID = 0L;
            private final String domainName$1;

            public final DomainRecord apply(package.DomainRecord x$5) {
                return x$5.domainRecord().toDomainRecord(this.domainName$1);
            }
            {
                this.domainName$1 = domainName$1;
            }
        }, ec);
    }

    public Future<DomainRecord> createA(String domainName, String recordName, Inet4Address recordData, DigitalOceanClient client, ExecutionContext ec) {
        Domain.CreateRecord record = new Domain.CreateRecord("A", (Option<String>)new Some((Object)recordName), recordData.getHostAddress(), Domain$CreateRecord$.MODULE$.apply$default$4(), Domain$CreateRecord$.MODULE$.apply$default$5(), Domain$CreateRecord$.MODULE$.apply$default$6());
        return this.createRecord(domainName, record, client, ec);
    }

    public Future<DomainRecord> createA(String domainName, String recordName, String recordData, DigitalOceanClient client, ExecutionContext ec) {
        Inet4Address address = (Inet4Address)InetAddress.getByName(recordData);
        return this.createA(domainName, recordName, address, client, ec);
    }

    public Future<DomainRecord> createAAAA(String domainName, String recordName, Inet6Address recordData, DigitalOceanClient client, ExecutionContext ec) {
        Domain.CreateRecord record = new Domain.CreateRecord("AAAA", (Option<String>)new Some((Object)recordName), recordData.getHostAddress(), Domain$CreateRecord$.MODULE$.apply$default$4(), Domain$CreateRecord$.MODULE$.apply$default$5(), Domain$CreateRecord$.MODULE$.apply$default$6());
        return this.createRecord(domainName, record, client, ec);
    }

    public Future<DomainRecord> createAAAA(String domainName, String recordName, String recordData, DigitalOceanClient client, ExecutionContext ec) {
        Inet6Address address = (Inet6Address)InetAddress.getByName(recordData);
        return this.createAAAA(domainName, recordName, address, client, ec);
    }

    public Future<DomainRecord> createCName(String domainName, String recordName, String recordData, DigitalOceanClient client, ExecutionContext ec) {
        Domain.CreateRecord record = new Domain.CreateRecord("CNAME", (Option<String>)new Some((Object)recordName), recordData, Domain$CreateRecord$.MODULE$.apply$default$4(), Domain$CreateRecord$.MODULE$.apply$default$5(), Domain$CreateRecord$.MODULE$.apply$default$6());
        return this.createRecord(domainName, record, client, ec);
    }

    public Future<DomainRecord> createMX(String domainName, String recordData, int recordPriority, DigitalOceanClient client, ExecutionContext ec) {
        if (recordPriority < 0 || recordPriority > 63335) {
            throw new IllegalArgumentException("priority");
        }
        String x$6 = "MX";
        String x$7 = recordData;
        Some x$8 = new Some((Object)BoxesRunTime.boxToInteger((int)recordPriority));
        Option<String> x$9 = Domain$CreateRecord$.MODULE$.apply$default$2();
        Option<Object> x$10 = Domain$CreateRecord$.MODULE$.apply$default$5();
        Option<Object> x$11 = Domain$CreateRecord$.MODULE$.apply$default$6();
        Domain.CreateRecord record = new Domain.CreateRecord(x$6, x$9, x$7, (Option<Object>)x$8, x$10, x$11);
        return this.createRecord(domainName, record, client, ec);
    }

    public Future<DomainRecord> createTxt(String domainName, String recordName, String recordData, DigitalOceanClient client, ExecutionContext ec) {
        Domain.CreateRecord record = new Domain.CreateRecord("TXT", (Option<String>)new Some((Object)recordName), recordData, Domain$CreateRecord$.MODULE$.apply$default$4(), Domain$CreateRecord$.MODULE$.apply$default$5(), Domain$CreateRecord$.MODULE$.apply$default$6());
        return this.createRecord(domainName, record, client, ec);
    }

    public Future<DomainRecord> createSrv(String domainName, String recordName, String recordData, int recordPriority, int recordWeight, DigitalOceanClient client, ExecutionContext ec) {
        if (recordPriority < 0 || recordPriority > 63335) {
            throw new IllegalArgumentException("recordPriority");
        }
        if (recordWeight < 0 || recordWeight > 63335) {
            throw new IllegalArgumentException("recordWeight");
        }
        String x$12 = "SRV";
        Some x$13 = new Some((Object)recordName);
        String x$14 = recordData;
        Some x$15 = new Some((Object)BoxesRunTime.boxToInteger((int)recordPriority));
        Some x$16 = new Some((Object)BoxesRunTime.boxToInteger((int)recordWeight));
        Option<Object> x$17 = Domain$CreateRecord$.MODULE$.apply$default$5();
        Domain.CreateRecord record = new Domain.CreateRecord(x$12, (Option<String>)x$13, x$14, (Option<Object>)x$15, x$17, (Option<Object>)x$16);
        return this.createRecord(domainName, record, client, ec);
    }

    public Future<DomainRecord> createNS(String domainName, String recordData, DigitalOceanClient client, ExecutionContext ec) {
        String x$18 = "NS";
        String x$19 = recordData;
        Option<String> x$20 = Domain$CreateRecord$.MODULE$.apply$default$2();
        Option<Object> x$21 = Domain$CreateRecord$.MODULE$.apply$default$4();
        Option<Object> x$22 = Domain$CreateRecord$.MODULE$.apply$default$5();
        Option<Object> x$23 = Domain$CreateRecord$.MODULE$.apply$default$6();
        Domain.CreateRecord record = new Domain.CreateRecord(x$18, x$20, x$19, x$21, x$22, x$23);
        return this.createRecord(domainName, record, client, ec);
    }

    public Domain apply(String name, Option<Object> ttl, Option<String> zoneFile) {
        return new Domain(name, ttl, zoneFile);
    }

    public Option<Tuple3<String, Option<Object>, Option<String>>> unapply(Domain x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.name(), x$0.ttl(), x$0.zoneFile()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Domain$() {
        MODULE$ = this;
        Path$class.$init$(this);
        Listable$class.$init$(this);
        this.path = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"domains"}));
    }
}

