/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.math.BigInteger;
import me.legrange.panstamp.Endpoint;
import me.legrange.panstamp.EndpointListener;
import me.legrange.panstamp.ModemException;
import me.legrange.panstamp.Network;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.NetworkListener;
import me.legrange.panstamp.PanStamp;
import me.legrange.panstamp.PanStampListener;
import me.legrange.panstamp.Parameter;
import me.legrange.panstamp.Register;
import me.legrange.panstamp.RegisterListener;

public class TestEvents {
    private static final String PORT = "/dev/tty.usbserial-A800HNMV";
    private static final int BAUD = 38400;
    private Network nw;
    private int seq = 0;

    public static void main(String ... args) throws Exception {
        TestEvents te = new TestEvents();
        te.connect();
        te.setupListeners();
        while (true) {
            Thread.sleep(1000L);
        }
    }

    private void connect() throws NetworkException {
        this.nw = Network.openSerial(PORT, 38400);
    }

    private void setupListeners() throws NetworkException {
        this.nw.addListener(new NetworkListener(){

            @Override
            public void deviceDetected(Network gw, PanStamp dev) {
                TestEvents.this.addPanStamp(dev);
                TestEvents.this.say("N: Device with address %d added to network", new Object[]{dev.getAddress()});
            }

            @Override
            public void deviceRemoved(Network gw, PanStamp dev) {
                TestEvents.this.say("N: Device with address %d removed to network", new Object[]{dev.getAddress()});
            }
        });
        for (PanStamp ps : this.nw.getDevices()) {
            this.addPanStamp(ps);
        }
    }

    private void addPanStamp(PanStamp ps) {
        ps.addListener(new PanStampListener(){

            @Override
            public void productCodeChange(PanStamp dev, int manufacturerId, int productId) {
                TestEvents.this.say("P: Product code for %d changed to %d/%d\n", new Object[]{dev.getAddress(), manufacturerId, productId});
            }

            @Override
            public void syncStateChange(PanStamp dev, int syncState) {
                TestEvents.this.say("P: Sync state for %d changed to %d\n", new Object[]{dev.getAddress(), syncState});
            }

            @Override
            public void registerDetected(PanStamp dev, Register reg) {
                TestEvents.this.addRegister(reg);
                TestEvents.this.say("P: Register %d detected for device %d", new Object[]{reg.getId(), dev.getAddress()});
            }

            @Override
            public void syncRequired(PanStamp dev) {
                TestEvents.this.say("P: Sync required for device %d", new Object[]{dev.getAddress()});
            }
        });
        for (Register reg : ps.getRegisters()) {
            this.addRegister(reg);
        }
    }

    private void addRegister(Register reg) {
        reg.addListener(new RegisterListener(){

            @Override
            public void valueReceived(Register reg, byte[] value) {
                TestEvents.this.say("R: Value for %d updated to '%s'", new Object[]{reg.getId(), TestEvents.this.formatBytes(value)});
            }

            @Override
            public void valueSet(Register reg, byte[] value) {
                TestEvents.this.say("R: Value for %d set to '%s'", new Object[]{reg.getId(), TestEvents.this.formatBytes(value)});
            }

            @Override
            public void endpointAdded(Register reg, Endpoint ep) {
                TestEvents.this.addEndpoint(ep);
                TestEvents.this.say("R: Endpoint '%s' added to %d", new Object[]{ep.getName(), reg.getId()});
            }

            @Override
            public void parameterAdded(Register reg, Parameter par) {
                TestEvents.this.say("R: Parameter '%s' added to %d", new Object[]{par.getName(), reg.getId()});
            }
        });
        for (Endpoint ep : reg.getEndpoints()) {
            this.addEndpoint(ep);
        }
    }

    private void addEndpoint(Endpoint ep) {
        ep.addListener(new EndpointListener(){

            public void valueReceived(Endpoint ep, Object value) {
                TestEvents.this.say("E: Value '%s' received for '%s'", new Object[]{ep.getName(), value});
            }
        });
    }

    private void disconnect() throws ModemException {
        this.nw.close();
    }

    private synchronized void say(String fmt, Object ... args) {
        System.out.printf("[%04d] ", this.seq);
        System.out.printf(fmt, args);
        if (!fmt.endsWith("\n")) {
            System.out.println();
        }
        ++this.seq;
    }

    private String formatBytes(byte[] val) {
        return new BigInteger(val).toString(16);
    }
}

