/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.legrange.panstamp.Endpoint;
import me.legrange.panstamp.EndpointListener;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.NoSuchUnitException;
import me.legrange.panstamp.Register;
import me.legrange.panstamp.definition.EndpointDefinition;
import me.legrange.panstamp.definition.Unit;
import me.legrange.panstamp.event.AbstractRegisterListener;

abstract class AbstractEndpoint<T>
implements Endpoint<T> {
    protected final Register reg;
    protected final EndpointDefinition epDef;
    private final CopyOnWriteArrayList<EndpointListener<T>> listeners;

    @Override
    public String getName() {
        return this.epDef.getName();
    }

    @Override
    public final List<String> getUnits() {
        LinkedList<String> res = new LinkedList<String>();
        for (Unit u : this.epDef.getUnits()) {
            res.add(u.getName());
        }
        return res;
    }

    @Override
    public final boolean hasValue() {
        return this.reg.hasValue();
    }

    @Override
    public synchronized void addListener(EndpointListener<T> el) {
        this.listeners.add(el);
    }

    @Override
    public synchronized void removeListener(EndpointListener<T> el) {
        this.listeners.remove(el);
    }

    @Override
    public final T getValue(String unit) throws NetworkException {
        return this.transformIn(this.getValue(), this.getUnit(unit));
    }

    @Override
    public void setValue(String unit, T value) throws NetworkException {
        this.setValue(this.transformOut(value, this.getUnit(unit)));
    }

    @Override
    public Register getRegister() {
        return this.reg;
    }

    protected abstract T transformOut(T var1, Unit var2);

    protected abstract T transformIn(T var1, Unit var2);

    protected final Unit getUnit(String name) throws NoSuchUnitException {
        for (Unit u : this.epDef.getUnits()) {
            if (!u.getName().equals(name)) continue;
            return u;
        }
        throw new NoSuchUnitException(String.format("No unit '%s' found in endpoint '%s'", name, this.getName()));
    }

    protected AbstractEndpoint(Register reg, EndpointDefinition epDef) {
        this.reg = reg;
        this.epDef = epDef;
        this.listeners = new CopyOnWriteArrayList();
        reg.addListener(new AbstractRegisterListener(){

            @Override
            public void valueReceived(Register reg, byte[] value) {
                for (final EndpointListener l : AbstractEndpoint.this.listeners) {
                    AbstractEndpoint.this.pool().submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                l.valueReceived(AbstractEndpoint.this, AbstractEndpoint.this.getValue());
                            }
                            catch (NetworkException ex) {
                                Logger.getLogger(AbstractEndpoint.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    });
                }
            }
        });
    }

    void destroy() {
        this.listeners.clear();
    }

    private ExecutorService pool() {
        return this.reg.getPool();
    }
}

