/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp;

import me.legrange.panstamp.AbstractEndpoint;
import me.legrange.panstamp.Endpoint;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.Register;
import me.legrange.panstamp.definition.EndpointDefinition;
import me.legrange.panstamp.definition.Unit;

final class BinaryEndpoint
extends AbstractEndpoint<Boolean> {
    BinaryEndpoint(Register reg, EndpointDefinition epDef) {
        super(reg, epDef);
    }

    @Override
    public Endpoint.Type getType() {
        return Endpoint.Type.BINARY;
    }

    @Override
    public Boolean getValue() throws NetworkException {
        int bitIdx;
        int byteIdx;
        byte[] val = this.reg.getValue();
        return (val[byteIdx = this.epDef.getPosition().getBytePos()] & 1 << (bitIdx = this.epDef.getPosition().getBitPos())) != 0;
    }

    @Override
    public void setValue(Boolean value) throws NetworkException {
        byte[] val = this.reg.getValue();
        int byteIdx = this.epDef.getPosition().getBytePos();
        int bitIdx = this.epDef.getPosition().getBitPos();
        val[byteIdx] = (byte)(val[byteIdx] & ~(1 << bitIdx) | (byte)(value != false ? 1 : 0) << bitIdx);
        this.reg.setValue(val);
    }

    @Override
    protected Boolean transformIn(Boolean value, Unit unit) {
        return value;
    }

    @Override
    protected Boolean transformOut(Boolean value, Unit unit) {
        return value;
    }
}

