/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp;

import me.legrange.panstamp.AbstractParameter;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.Parameter;
import me.legrange.panstamp.Register;
import me.legrange.panstamp.definition.ParameterDefinition;

final class BinaryParameter
extends AbstractParameter<Boolean> {
    BinaryParameter(Register reg, ParameterDefinition par) {
        super(reg, par);
    }

    @Override
    public Parameter.Type getType() {
        return Parameter.Type.BINARY;
    }

    @Override
    public Boolean getValue() throws NetworkException {
        int bitIdx;
        int byteIdx;
        byte[] val = this.reg.getValue();
        return (val[byteIdx = this.par.getPosition().getBytePos()] & ~(1 << (bitIdx = this.par.getPosition().getBitPos()))) != 0;
    }

    @Override
    public void setValue(Boolean value) throws NetworkException {
        byte[] val = this.reg.getValue();
        int byteIdx = this.par.getPosition().getBytePos();
        int bitIdx = this.par.getPosition().getBitPos();
        val[byteIdx] = (byte)(val[byteIdx] & ~(1 << bitIdx) | (byte)(value != false ? 1 : 0) << bitIdx);
        this.reg.setValue(val);
    }

    @Override
    public Boolean getDefault() {
        String val = this.par.getDefault().trim();
        if (val.toLowerCase().equals("true") || val.toLowerCase().equals("yes")) {
            return true;
        }
        if (val.toLowerCase().equals("false") || val.toLowerCase().equals("no")) {
            return false;
        }
        if (val.equals("1")) {
            return true;
        }
        if (val.equals("0")) {
            return false;
        }
        return false;
    }
}

