/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp;

import me.legrange.panstamp.AbstractEndpoint;
import me.legrange.panstamp.Endpoint;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.Register;
import me.legrange.panstamp.definition.EndpointDefinition;
import me.legrange.panstamp.definition.Unit;

final class IntegerEndpoint
extends AbstractEndpoint<Integer> {
    IntegerEndpoint(Register reg, EndpointDefinition epDef) {
        super(reg, epDef);
    }

    @Override
    public Endpoint.Type getType() {
        return Endpoint.Type.INTEGER;
    }

    @Override
    public Integer getValue() throws NetworkException {
        byte[] bytes = this.reg.getValue();
        if (bytes.length > 0) {
            int val = 0;
            for (int i = 0; i < this.epDef.getSize().getBytes(); ++i) {
                val <<= 8;
                val |= bytes[this.epDef.getPosition().getBytePos() + i] & 0xFF;
            }
            return val;
        }
        return null;
    }

    @Override
    public void setValue(Integer value) throws NetworkException {
        byte[] bytes = this.reg.hasValue() ? this.reg.getValue() : new byte[this.epDef.getRegister().getByteSize()];
        long val = value.longValue();
        for (int i = this.epDef.getSize().getBytes() - 1; i >= 0; --i) {
            bytes[this.epDef.getPosition().getBytePos() + i] = (byte)(val & 0xFFL);
            val >>>= 8;
        }
        this.reg.setValue(bytes);
    }

    @Override
    protected Integer transformIn(Integer value, Unit unit) {
        Double d = (double)value.intValue() * unit.getFactor() + unit.getOffset();
        return d.intValue();
    }

    @Override
    protected Integer transformOut(Integer value, Unit unit) {
        Double d = ((double)value.intValue() - unit.getOffset()) / unit.getFactor();
        return d.intValue();
    }
}

