/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp;

import me.legrange.panstamp.AbstractParameter;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.Parameter;
import me.legrange.panstamp.Register;
import me.legrange.panstamp.definition.ParameterDefinition;

final class IntegerParameter
extends AbstractParameter<Integer> {
    IntegerParameter(Register reg, ParameterDefinition par) {
        super(reg, par);
    }

    @Override
    public Parameter.Type getType() {
        return Parameter.Type.INTEGER;
    }

    @Override
    public Integer getValue() throws NetworkException {
        byte[] bytes = this.reg.getValue();
        int val = 0;
        for (int i = 0; i < this.par.getSize().getBytes(); ++i) {
            val <<= 8;
            val |= bytes[this.par.getPosition().getBytePos() + i] & 0xFF;
        }
        return val;
    }

    @Override
    public void setValue(Integer value) throws NetworkException {
        long val = value.longValue();
        byte[] bytes = new byte[this.par.getSize().getBytes()];
        for (int i = this.par.getSize().getBytes() - 1; i >= 0; --i) {
            bytes[i] = (byte)(val & 0xFFL);
            val >>>= 8;
        }
        this.reg.setValue(bytes);
    }

    @Override
    public Integer getDefault() {
        return Integer.parseInt(this.par.getDefault());
    }
}

