/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.legrange.panstamp.DeviceStateStore;
import me.legrange.panstamp.Register;

final class MemoryStore
implements DeviceStateStore {
    private final Map<Integer, Map<Integer, byte[]>> cache = new ConcurrentHashMap<Integer, Map<Integer, byte[]>>();

    MemoryStore() {
    }

    @Override
    public boolean hasRegisterValue(Register reg) {
        return this.mapForAddress(reg.getDevice().getAddress()).get(reg.getId()) != null;
    }

    @Override
    public byte[] getRegisterValue(Register reg) {
        return this.mapForAddress(reg.getDevice().getAddress()).get(reg.getId());
    }

    @Override
    public void setRegisterValue(Register reg, byte[] value) {
        this.mapForAddress(reg.getDevice().getAddress()).put(reg.getId(), value);
    }

    private Map<Integer, byte[]> mapForAddress(int address) {
        Map<Integer, byte[]> map = this.cache.get(address);
        if (map == null) {
            map = new ConcurrentHashMap<Integer, byte[]>();
            this.cache.put(address, map);
        }
        return map;
    }
}

