/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.legrange.panstamp.DeviceLibrary;
import me.legrange.panstamp.DeviceStateStore;
import me.legrange.panstamp.MemoryStore;
import me.legrange.panstamp.ModemException;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.NetworkListener;
import me.legrange.panstamp.NoSuchUnitException;
import me.legrange.panstamp.NodeNotFoundException;
import me.legrange.panstamp.PanStamp;
import me.legrange.panstamp.Register;
import me.legrange.panstamp.StandardRegister;
import me.legrange.panstamp.definition.DeviceDefinition;
import me.legrange.panstamp.xml.ClassLoaderLibrary;
import me.legrange.swap.MessageListener;
import me.legrange.swap.ModemSetup;
import me.legrange.swap.SerialModem;
import me.legrange.swap.SwapException;
import me.legrange.swap.SwapMessage;
import me.legrange.swap.SwapModem;
import me.legrange.swap.UserMessage;
import me.legrange.swap.tcp.TcpModem;

public final class Network {
    private final SwapModem modem;
    private final Receiver receiver;
    private DeviceLibrary lib;
    private DeviceStateStore store;
    private final Map<Integer, PanStamp> devices = new HashMap<Integer, PanStamp>();
    private final List<NetworkListener> listeners = new LinkedList<NetworkListener>();
    private static final Logger logger = Logger.getLogger(Network.class.getName());
    private ModemSetup setup;
    private final ExecutorService pool = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "PanStamp Library Task");
            t.setDaemon(true);
            return t;
        }
    });

    public static Network openSerial(String port, int baud) throws NetworkException {
        SerialModem sm = new SerialModem(port, baud);
        Network nw = Network.create(sm);
        nw.open();
        return nw;
    }

    public static Network openTcp(String host, int port) throws NetworkException {
        TcpModem tm = new TcpModem(host, port);
        Network nw = Network.create(tm);
        nw.open();
        return nw;
    }

    public static Network create(SwapModem modem) {
        return new Network(modem);
    }

    public boolean isOpen() {
        return this.modem.isOpen();
    }

    public void open() throws NetworkException {
        this.modem.addListener(this.receiver);
        try {
            this.modem.open();
            this.getSetup();
        }
        catch (SwapException ex) {
            throw new NetworkException(String.format("Error opening SWAP modem: %s", ex.getMessage()), ex);
        }
    }

    public void close() throws ModemException {
        try {
            this.modem.close();
        }
        catch (SwapException ex) {
            throw new ModemException(ex.getMessage(), ex);
        }
        finally {
            this.modem.removeListener(this.receiver);
            this.devices.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDevice(int address) {
        Map<Integer, PanStamp> map = this.devices;
        synchronized (map) {
            return this.devices.get(address) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PanStamp getDevice(int address) throws NodeNotFoundException {
        Map<Integer, PanStamp> map = this.devices;
        synchronized (map) {
            PanStamp dev = this.devices.get(address);
            if (dev == null) {
                throw new NodeNotFoundException(String.format("No device found for address %02x", address));
            }
            return dev;
        }
    }

    public List<PanStamp> getDevices() {
        ArrayList<PanStamp> res = new ArrayList<PanStamp>();
        res.addAll(this.devices.values());
        return res;
    }

    public void addDevice(PanStamp ps) {
        this.devices.put(ps.getAddress(), ps);
        this.fireDeviceDetected(ps);
        ps.getDefinition();
    }

    public void removeDevice(int address) {
        PanStamp ps = this.devices.get(address);
        if (ps != null) {
            this.fireDeviceRemoved(ps);
            ps.destroy();
            this.devices.remove(address);
        }
    }

    public void addListener(NetworkListener l) {
        this.listeners.add(l);
    }

    public void removeListener(NetworkListener l) {
        this.listeners.remove(l);
    }

    public SwapModem getSWAPModem() {
        return this.modem;
    }

    public DeviceLibrary getDeviceLibrary() {
        return this.lib;
    }

    public DeviceStateStore getDeviceStore() {
        return this.store;
    }

    public void setDeviceLibrary(DeviceLibrary lib) {
        this.lib = lib;
    }

    public void setDeviceStore(DeviceStateStore store) {
        this.store = store;
    }

    public int getNetworkId() throws ModemException {
        return this.getSetup().getNetworkID();
    }

    public int getChannel() throws ModemException {
        return this.getSetup().getChannel();
    }

    public int getDeviceAddress() throws ModemException {
        return this.getSetup().getDeviceAddress();
    }

    public int getSecurityOption() {
        return 0;
    }

    public void setNetworkId(int id) throws NetworkException {
        this.getSetup().setNetworkID(id);
    }

    public void setDeviceAddress(int addr) throws NetworkException {
        this.getSetup().setDeviceAddress(addr);
    }

    public void setChannel(int channel) throws NetworkException {
        this.getSetup().setChannel(channel);
    }

    public void setSecurityOption(int secOpt) {
    }

    void sendCommandMessage(PanStamp dev, int register, byte[] value) throws ModemException {
        UserMessage msg = new UserMessage(dev.hasExtendedAddress(), SwapMessage.Type.COMMAND, this.getSetup().getDeviceAddress(), dev.getAddress(), register, value);
        msg.setRegisterAddress(dev.getAddress());
        this.send(msg);
    }

    void sendQueryMessage(PanStamp dev, int register) throws ModemException {
        UserMessage msg = new UserMessage(dev.hasExtendedAddress(), SwapMessage.Type.QUERY, 255, dev.getAddress(), register, new byte[0]);
        msg.setRegisterAddress(dev.getAddress());
        this.send(msg);
    }

    DeviceDefinition getDeviceDefinition(int manId, int prodId) throws NetworkException {
        return this.lib.getDeviceDefinition(manId, prodId);
    }

    ExecutorService getPool() {
        return this.pool;
    }

    private Network(SwapModem modem) {
        this.modem = modem;
        this.lib = new ClassLoaderLibrary();
        this.store = new MemoryStore();
        this.receiver = new Receiver();
    }

    private void fireDeviceDetected(final PanStamp dev) {
        for (final NetworkListener l : this.listeners) {
            this.getPool().submit(new Runnable(){

                @Override
                public void run() {
                    l.deviceDetected(Network.this, dev);
                }
            });
        }
    }

    private void fireDeviceRemoved(final PanStamp dev) {
        for (final NetworkListener l : this.listeners) {
            this.getPool().submit(new Runnable(){

                @Override
                public void run() {
                    l.deviceRemoved(Network.this, dev);
                }
            });
        }
    }

    private void send(SwapMessage msg) throws ModemException {
        try {
            this.modem.send(msg);
        }
        catch (SwapException ex) {
            throw new ModemException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNetwork(SwapMessage msg) throws NetworkException {
        int address = msg.getSender();
        Map<Integer, PanStamp> map = this.devices;
        synchronized (map) {
            if (!this.hasDevice(address)) {
                try {
                    PanStamp dev = new PanStamp(this, address);
                    this.addDevice(dev);
                    for (StandardRegister sr : StandardRegister.ALL) {
                        Register reg = dev.getRegister(sr.getId());
                        if (reg.hasValue() || !this.store.hasRegisterValue(reg)) continue;
                        reg.setValue(this.store.getRegisterValue(reg));
                    }
                }
                catch (NoSuchUnitException ex) {
                    throw new ModemException(ex.getMessage(), ex);
                }
            }
        }
    }

    private void processStatusMessage(SwapMessage msg) {
        try {
            this.updateNetwork(msg);
            PanStamp dev = this.getDevice(msg.getRegisterAddress());
            dev.statusMessageReceived(msg);
            if (msg.isStandardRegister()) {
                StandardRegister sr = StandardRegister.forId(msg.getRegisterID());
                Register reg = dev.getRegister(msg.getRegisterID());
                this.store.setRegisterValue(reg, reg.getValue());
            }
        }
        catch (NetworkException ex) {
            Logger.getLogger(Network.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private synchronized ModemSetup getSetup() throws ModemException {
        if (this.setup == null) {
            try {
                this.setup = this.modem.getSetup();
            }
            catch (SwapException ex) {
                throw new ModemException(ex.getMessage(), ex);
            }
        }
        return this.setup;
    }

    private class Receiver
    implements MessageListener {
        private Receiver() {
        }

        @Override
        public void messageReceived(SwapMessage msg) {
            switch (msg.getType()) {
                case COMMAND: 
                case QUERY: {
                    try {
                        Network.this.updateNetwork(msg);
                    }
                    catch (NetworkException ex) {
                        Logger.getLogger(Network.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                case STATUS: {
                    Network.this.processStatusMessage(msg);
                }
            }
        }

        @Override
        public void messageSent(SwapMessage msg) {
        }
    }
}

