/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp;

import me.legrange.panstamp.AbstractEndpoint;
import me.legrange.panstamp.Endpoint;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.Register;
import me.legrange.panstamp.definition.EndpointDefinition;
import me.legrange.panstamp.definition.Unit;

final class NumberEndpoint
extends AbstractEndpoint<Double> {
    NumberEndpoint(Register reg, EndpointDefinition epDef) {
        super(reg, epDef);
    }

    @Override
    public Endpoint.Type getType() {
        return Endpoint.Type.NUMBER;
    }

    @Override
    public Double getValue() throws NetworkException {
        byte[] bytes = this.reg.getValue();
        long val = 0L;
        for (int i = 0; i < this.epDef.getSize().getBytes(); ++i) {
            val <<= 8;
            val |= (long)(bytes[this.epDef.getPosition().getBytePos() + i] & 0xFF);
        }
        return val;
    }

    @Override
    public void setValue(Double value) throws NetworkException {
        long val = value.longValue();
        byte[] bytes = new byte[this.epDef.getSize().getBytes()];
        for (int i = this.epDef.getSize().getBytes() - 1; i >= 0; --i) {
            bytes[i] = (byte)(val & 0xFFL);
            val >>>= 8;
        }
        this.reg.setValue(bytes);
    }

    @Override
    protected Double transformIn(Double value, Unit unit) {
        return value * unit.getFactor() + unit.getOffset();
    }

    @Override
    protected Double transformOut(Double value, Unit unit) {
        return (value - unit.getOffset()) / unit.getFactor();
    }
}

