/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.legrange.panstamp.Endpoint;
import me.legrange.panstamp.EndpointListener;
import me.legrange.panstamp.ModemException;
import me.legrange.panstamp.Network;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.PanStampListener;
import me.legrange.panstamp.Register;
import me.legrange.panstamp.RegisterListener;
import me.legrange.panstamp.StandardEndpoint;
import me.legrange.panstamp.StandardRegister;
import me.legrange.panstamp.definition.DeviceDefinition;
import me.legrange.panstamp.definition.EndpointDefinition;
import me.legrange.panstamp.definition.ParameterDefinition;
import me.legrange.panstamp.definition.RegisterDefinition;
import me.legrange.panstamp.event.AbstractPanStampListener;
import me.legrange.panstamp.event.AbstractRegisterListener;
import me.legrange.swap.SwapMessage;

public final class PanStamp {
    private final int address;
    private DeviceDefinition def;
    private final Network gw;
    private int manufacturerId;
    private int productId;
    private int syncState;
    private boolean extended;
    private final Map<Integer, Register> registers = new ConcurrentHashMap<Integer, Register>();
    private final transient List<PanStampListener> listeners = new CopyOnWriteArrayList<PanStampListener>();

    public int getAddress() {
        return this.address;
    }

    public int getChannel() throws NetworkException {
        Integer v = this.getIntValue(StandardEndpoint.FREQUENCY_CHANNEL);
        if (v != null) {
            return v;
        }
        return this.getGateway().getChannel();
    }

    public int getTxInterval() throws NetworkException {
        return this.getIntValue(StandardEndpoint.PERIODIC_TX_INTERVAL, 0);
    }

    public int getSecurityOption() throws NetworkException {
        return this.getIntValue(StandardEndpoint.SECURITY_OPTION, 0);
    }

    public int getNetwork() throws NetworkException {
        Integer v = this.getIntValue(StandardEndpoint.NETWORK_ID);
        if (v != null) {
            return v;
        }
        return this.getGateway().getNetworkId();
    }

    public void setAddress(int addr) throws NetworkException {
        if (addr != this.getAddress()) {
            this.setIntValue(StandardEndpoint.DEVICE_ADDRESS, addr);
        }
    }

    public void setNetwork(int network) throws NetworkException {
        if (network != this.getNetwork()) {
            this.setIntValue(StandardEndpoint.NETWORK_ID, network);
        }
    }

    public void setChannel(int channel) throws NetworkException {
        if (channel != this.getChannel()) {
            this.setIntValue(StandardEndpoint.FREQUENCY_CHANNEL, channel);
        }
    }

    public void setSecurityOption(int option) throws NetworkException {
        if (option != this.getSecurityOption()) {
            this.setIntValue(StandardEndpoint.SECURITY_OPTION, option);
        }
    }

    public void setTxInterval(int txInterval) throws NetworkException {
        if (txInterval != this.getTxInterval()) {
            this.setIntValue(StandardEndpoint.PERIODIC_TX_INTERVAL, txInterval);
        }
    }

    public int getManufacturerId() throws NetworkException {
        return this.manufacturerId;
    }

    public int getProductId() throws NetworkException {
        return this.productId;
    }

    public Network getGateway() {
        return this.gw;
    }

    public String getName() {
        if (this.def != null) {
            return this.def.getProduct();
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Register getRegister(int id) {
        Register reg;
        Map<Integer, Register> map = this.registers;
        synchronized (map) {
            reg = this.registers.get(id);
            if (reg == null) {
                reg = new Register(this, id);
                this.registers.put(id, reg);
            }
        }
        return reg;
    }

    public List<Register> getRegisters() {
        ArrayList<Register> all = new ArrayList<Register>();
        all.addAll(this.registers.values());
        Collections.sort(all, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Register)o1).getId() - ((Register)o2).getId();
            }
        });
        return all;
    }

    public boolean hasRegister(int id) {
        return this.registers.get(id) != null;
    }

    public void addListener(PanStampListener l) {
        this.listeners.add(l);
    }

    public void removeListener(PanStampListener l) {
        this.listeners.remove(l);
    }

    public PanStamp(Network gw, int address) throws NetworkException {
        this.gw = gw;
        this.address = address;
        this.extended = address > 255;
        for (StandardRegister reg : StandardRegister.ALL) {
            Register impl = new Register(this, reg);
            this.registers.put(reg.getId(), impl);
        }
        this.getRegister(StandardRegister.PRODUCT_CODE.getId()).addListener(this.productCodeListener());
        this.getRegister(StandardRegister.SYSTEM_STATE.getId()).getEndpoint(StandardEndpoint.SYSTEM_STATE.getName()).addListener(this.systemStateListener());
    }

    void destroy() {
        for (Register reg : this.registers.values()) {
            reg.destroy();
        }
        this.listeners.clear();
        this.registers.clear();
    }

    DeviceDefinition getDefinition() {
        return this.def;
    }

    void sendQueryMessage(int id) throws ModemException {
        this.gw.sendQueryMessage(this, id);
    }

    void sendCommandMessage(int id, byte[] value) throws NetworkException {
        if (this.isSleeper()) {
            this.queue(id, value);
        } else {
            this.gw.sendCommandMessage(this, id, value);
        }
    }

    void statusMessageReceived(SwapMessage msg) {
        Register reg = this.getRegister(msg.getRegisterID());
        boolean isNew = !reg.hasValue();
        reg.valueReceived(msg.getRegisterValue());
        if (isNew) {
            this.fireRegisterDetected(reg);
        }
    }

    boolean hasExtendedAddress() {
        return this.extended;
    }

    ExecutorService getPool() {
        return this.gw.getPool();
    }

    private void fireRegisterDetected(final Register reg) {
        for (final PanStampListener l : this.listeners) {
            this.getPool().submit(new Runnable(){

                @Override
                public void run() {
                    l.registerDetected(PanStamp.this, reg);
                }
            });
        }
    }

    private int getIntValue(StandardEndpoint epDef, int defaultValue) throws NetworkException {
        Integer v = this.getIntValue(epDef);
        if (v != null) {
            return v;
        }
        return defaultValue;
    }

    private void setIntValue(StandardEndpoint epDef, int val) throws NetworkException {
        Register reg = this.getRegister(epDef.getRegister().getId());
        Endpoint ep = reg.getEndpoint(epDef.getName());
        ep.setValue(val);
    }

    private Integer getIntValue(StandardEndpoint epDef) throws NetworkException {
        Register reg = this.getRegister(epDef.getRegister().getId());
        if (reg.hasValue()) {
            Endpoint ep = reg.getEndpoint(epDef.getName());
            return (Integer)ep.getValue();
        }
        return null;
    }

    private void queue(int id, byte[] value) {
        this.addListener(new UpdateOnSync(id, value));
        this.fireSyncRequired();
    }

    private boolean isSleeper() throws NetworkException {
        if (this.def != null) {
            return this.def.isPowerDownMode();
        }
        Endpoint ep = this.getRegister(StandardRegister.SYSTEM_STATE.getId()).getEndpoint(StandardEndpoint.SYSTEM_STATE.getName());
        if (!ep.hasValue()) {
            return true;
        }
        int v = (Integer)ep.getValue();
        return v != 3 && v != 1;
    }

    private EndpointListener systemStateListener() {
        return new EndpointListener<Integer>(){

            @Override
            public void valueReceived(Endpoint<Integer> ep, Integer syncState) {
                PanStamp.this.fireSyncStateChanged(syncState);
            }
        };
    }

    private void fireSyncRequired() {
        for (final PanStampListener l : this.listeners) {
            this.getPool().submit(new Runnable(){

                @Override
                public void run() {
                    l.syncStateChange(PanStamp.this, PanStamp.this.syncState);
                }
            });
        }
    }

    private void fireSyncStateChanged(final int syncState) {
        for (final PanStampListener l : this.listeners) {
            this.getPool().submit(new Runnable(){

                @Override
                public void run() {
                    l.syncStateChange(PanStamp.this, syncState);
                }
            });
        }
    }

    private void fireProductCodeChange(final int manufacturerId, final int productId) {
        for (final PanStampListener l : this.listeners) {
            this.getPool().submit(new Runnable(){

                @Override
                public void run() {
                    l.productCodeChange(PanStamp.this, manufacturerId, productId);
                }
            });
        }
    }

    private RegisterListener productCodeListener() {
        return new AbstractRegisterListener(){

            @Override
            public void valueReceived(Register reg, byte[] value) {
                try {
                    int mfId = PanStamp.this.getManufacturerIdFromRegister();
                    int pdId = PanStamp.this.getProductIdFromRegister();
                    if (mfId != PanStamp.this.getManufacturerId() || pdId != PanStamp.this.getProductId()) {
                        PanStamp.this.manufacturerId = mfId;
                        PanStamp.this.productId = pdId;
                        if (PanStamp.this.manufacturerId != 0 && PanStamp.this.productId != 0) {
                            PanStamp.this.loadDefinition();
                        }
                        PanStamp.this.fireProductCodeChange(mfId, pdId);
                    }
                }
                catch (NetworkException ex) {
                    Logger.getLogger(PanStamp.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            @Override
            public void valueSet(Register reg, byte[] value) {
                try {
                    int mfId = PanStamp.this.getManufacturerIdFromRegister();
                    int pdId = PanStamp.this.getProductIdFromRegister();
                    if (mfId != PanStamp.this.getManufacturerId() || pdId != PanStamp.this.getProductId()) {
                        PanStamp.this.manufacturerId = mfId;
                        PanStamp.this.productId = pdId;
                        if (PanStamp.this.manufacturerId != 0 && PanStamp.this.productId != 0) {
                            PanStamp.this.loadDefinition();
                        }
                        PanStamp.this.fireProductCodeChange(PanStamp.this.manufacturerId, PanStamp.this.productId);
                    }
                }
                catch (NetworkException ex) {
                    Logger.getLogger(PanStamp.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
    }

    private void loadDefinition() throws NetworkException {
        this.def = this.gw.getDeviceDefinition(this.getManufacturerId(), this.getProductId());
        List<RegisterDefinition> rpDefs = this.def.getRegisters();
        for (RegisterDefinition rpDef : rpDefs) {
            Register reg = this.getRegister(rpDef.getId());
            for (EndpointDefinition epDef : rpDef.getEndpoints()) {
                reg.addEndpoint(epDef);
            }
            for (ParameterDefinition par : rpDef.getParameters()) {
                reg.addParameter(par);
            }
        }
    }

    private int getManufacturerIdFromRegister() throws NetworkException {
        Register reg = this.getRegister(StandardRegister.PRODUCT_CODE.getId());
        if (reg.hasValue()) {
            byte[] val = reg.getValue();
            return val[0] << 24 | val[1] << 16 | val[2] << 8 | val[3];
        }
        return 0;
    }

    private int getProductIdFromRegister() throws NetworkException {
        Register reg = this.getRegister(StandardRegister.PRODUCT_CODE.getId());
        if (reg.hasValue()) {
            byte[] val = reg.getValue();
            return val[4] << 24 | val[5] << 16 | val[6] << 8 | val[7];
        }
        return 0;
    }

    private class UpdateOnSync
    extends AbstractPanStampListener {
        private final int id;
        private final byte[] val;

        private UpdateOnSync(int id, byte[] val) {
            this.id = id;
            this.val = val;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void syncStateChange(PanStamp dev, int syncState) {
            switch (syncState) {
                case 1: 
                case 3: {
                    try {
                        PanStamp.this.gw.sendCommandMessage(PanStamp.this, this.id, this.val);
                        break;
                    }
                    catch (ModemException ex) {
                        Logger.getLogger(PanStamp.class.getName()).log(Level.SEVERE, null, ex);
                        break;
                    }
                    finally {
                        PanStamp.this.removeListener(this);
                    }
                }
            }
        }
    }
}

