/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import me.legrange.panstamp.AbstractEndpoint;
import me.legrange.panstamp.AbstractParameter;
import me.legrange.panstamp.BinaryEndpoint;
import me.legrange.panstamp.BinaryParameter;
import me.legrange.panstamp.Endpoint;
import me.legrange.panstamp.EndpointNotFoundException;
import me.legrange.panstamp.IntegerEndpoint;
import me.legrange.panstamp.IntegerParameter;
import me.legrange.panstamp.ModemException;
import me.legrange.panstamp.MoteException;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.NoSuchUnitException;
import me.legrange.panstamp.NoValueException;
import me.legrange.panstamp.NumberEndpoint;
import me.legrange.panstamp.NumberParameter;
import me.legrange.panstamp.PanStamp;
import me.legrange.panstamp.Parameter;
import me.legrange.panstamp.RegisterListener;
import me.legrange.panstamp.StandardRegister;
import me.legrange.panstamp.StringEndpoint;
import me.legrange.panstamp.StringParameter;
import me.legrange.panstamp.definition.DeviceDefinition;
import me.legrange.panstamp.definition.EndpointDefinition;
import me.legrange.panstamp.definition.ParameterDefinition;

public final class Register {
    private final PanStamp dev;
    private final int id;
    private String name = "";
    private final Map<String, AbstractEndpoint> endpoints = new ConcurrentHashMap<String, AbstractEndpoint>();
    private final Map<String, AbstractParameter> parameters = new ConcurrentHashMap<String, AbstractParameter>();
    private final List<RegisterListener> listeners = new CopyOnWriteArrayList<RegisterListener>();
    private byte[] value;

    public int getId() {
        return this.id;
    }

    public String getName() {
        DeviceDefinition def = this.dev.getDefinition();
        if (def != null && def.hasRegister(this.id)) {
            return def.getRegister(this.id).getName();
        }
        return this.name;
    }

    public PanStamp getDevice() {
        return this.dev;
    }

    public List<Endpoint> getEndpoints() {
        ArrayList<Endpoint> all = new ArrayList<Endpoint>();
        all.addAll(this.endpoints.values());
        return all;
    }

    public void addListener(RegisterListener l) {
        this.listeners.add(l);
    }

    public void removeListener(RegisterListener l) {
        this.listeners.remove(l);
    }

    public void setValue(byte[] value) throws NetworkException {
        try {
            if (this.dev.getGateway().isOpen()) {
                this.dev.sendCommandMessage(this.id, value);
            } else {
                this.value = value;
            }
            this.fireValueSet(value);
        }
        catch (ModemException e) {
            throw new MoteException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getValue() throws NoValueException {
        Register register = this;
        synchronized (register) {
            if (this.value == null) {
                throw new NoValueException(String.format("No value received for register %d", this.id));
            }
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasValue() {
        Register register = this;
        synchronized (register) {
            return this.value != null;
        }
    }

    public Endpoint getEndpoint(String name) throws EndpointNotFoundException {
        Endpoint ep = this.endpoints.get(name);
        if (ep == null) {
            throw new EndpointNotFoundException(String.format("Could not find endpoint '%s' in register %d", name, this.id));
        }
        return ep;
    }

    public boolean hasEndpoint(String name) throws NetworkException {
        return this.endpoints.get(name) != null;
    }

    public List<Parameter> getParameters() {
        ArrayList<Parameter> all = new ArrayList<Parameter>();
        all.addAll(this.parameters.values());
        return all;
    }

    public boolean isStandard() {
        return this.id <= StandardRegister.MAX.getId();
    }

    void destroy() {
        for (AbstractEndpoint ep : this.endpoints.values()) {
            ep.destroy();
        }
        this.listeners.clear();
        this.endpoints.clear();
        this.parameters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void valueReceived(byte[] value) {
        Register register = this;
        synchronized (register) {
            this.value = value;
        }
        this.fireValueReceived(value);
    }

    void addEndpoint(EndpointDefinition def) {
        AbstractEndpoint ep = this.makeEndpoint(def);
        this.endpoints.put(def.getName(), ep);
        this.fireEndpointAdded(ep);
    }

    void addParameter(ParameterDefinition def) {
        AbstractParameter par = this.makeParameter(def);
        this.parameters.put(def.getName(), par);
        this.fireParameterAdded(par);
    }

    ExecutorService getPool() {
        return this.dev.getPool();
    }

    Register(PanStamp mote, int id) {
        this.dev = mote;
        this.id = id;
    }

    Register(PanStamp mote, StandardRegister reg) throws NoSuchUnitException {
        this(mote, reg.getId());
        this.name = reg.getName();
        for (EndpointDefinition sep : reg.getEndpoints()) {
            this.addEndpoint(sep);
        }
    }

    private void fireValueReceived(final byte[] value) {
        for (final RegisterListener l : this.listeners) {
            this.getPool().submit(new Runnable(){

                @Override
                public void run() {
                    l.valueReceived(Register.this, value);
                }
            });
        }
    }

    private void fireValueSet(final byte[] value) {
        for (final RegisterListener l : this.listeners) {
            this.getPool().submit(new Runnable(){

                @Override
                public void run() {
                    l.valueSet(Register.this, value);
                }
            });
        }
    }

    private void fireEndpointAdded(final Endpoint ep) {
        for (final RegisterListener l : this.listeners) {
            this.getPool().submit(new Runnable(){

                @Override
                public void run() {
                    l.endpointAdded(Register.this, ep);
                }
            });
        }
    }

    private void fireParameterAdded(final Parameter par) {
        for (final RegisterListener l : this.listeners) {
            this.getPool().submit(new Runnable(){

                @Override
                public void run() {
                    l.parameterAdded(Register.this, par);
                }
            });
        }
    }

    private AbstractEndpoint makeEndpoint(EndpointDefinition epDef) {
        switch (epDef.getType()) {
            case NUMBER: {
                return new NumberEndpoint(this, epDef);
            }
            case STRING: {
                return new StringEndpoint(this, epDef);
            }
            case BINARY: {
                return new BinaryEndpoint(this, epDef);
            }
            case INTEGER: {
                return new IntegerEndpoint(this, epDef);
            }
        }
        throw new RuntimeException(String.format("Unknown end point type '%s'. BUG!", new Object[]{epDef.getType()}));
    }

    private AbstractParameter makeParameter(ParameterDefinition def) {
        switch (def.getType()) {
            case NUMBER: {
                return new NumberParameter(this, def);
            }
            case STRING: {
                return new StringParameter(this, def);
            }
            case BINARY: {
                return new BinaryParameter(this, def);
            }
            case INTEGER: {
                return new IntegerParameter(this, def);
            }
        }
        throw new RuntimeException(String.format("Unknown parameter type '%s'. BUG!", new Object[]{def.getType()}));
    }
}

