/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp;

import me.legrange.panstamp.AbstractEndpoint;
import me.legrange.panstamp.Endpoint;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.Register;
import me.legrange.panstamp.definition.EndpointDefinition;
import me.legrange.panstamp.definition.Unit;

final class StringEndpoint
extends AbstractEndpoint<String> {
    StringEndpoint(Register reg, EndpointDefinition epDef) {
        super(reg, epDef);
    }

    @Override
    public Endpoint.Type getType() {
        return Endpoint.Type.STRING;
    }

    @Override
    protected String transformIn(String value, Unit unit) {
        return value;
    }

    @Override
    public String getValue() throws NetworkException {
        byte[] bytes = this.reg.getValue();
        byte[] keep = new byte[this.epDef.getSize().getBytes()];
        System.arraycopy(bytes, this.epDef.getPosition().getBytePos(), keep, 0, this.epDef.getSize().getBytes());
        return new String(keep);
    }

    @Override
    protected String transformOut(String value, Unit unit) {
        return value;
    }

    @Override
    public void setValue(String value) throws NetworkException {
        int len = this.epDef.getSize().getBytes();
        if (value.length() > len) {
            value = value.substring(0, len - 1);
        }
        byte[] bytes = new byte[len];
        System.arraycopy(value.getBytes(), 0, bytes, this.epDef.getPosition().getBytePos(), value.length());
    }
}

