/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp;

import me.legrange.panstamp.AbstractParameter;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.Parameter;
import me.legrange.panstamp.Register;
import me.legrange.panstamp.definition.ParameterDefinition;

final class StringParameter
extends AbstractParameter<String> {
    StringParameter(Register reg, ParameterDefinition epDef) {
        super(reg, epDef);
    }

    @Override
    public Parameter.Type getType() {
        return Parameter.Type.STRING;
    }

    @Override
    public String getValue() throws NetworkException {
        byte[] bytes = this.reg.getValue();
        byte[] keep = new byte[this.par.getSize().getBytes()];
        System.arraycopy(bytes, this.par.getPosition().getBytePos(), keep, 0, this.par.getSize().getBytes());
        return new String(keep);
    }

    @Override
    public void setValue(String value) throws NetworkException {
        int len = this.par.getSize().getBytes();
        if (value.length() > len) {
            value = value.substring(0, len - 1);
        }
        byte[] bytes = new byte[len];
        System.arraycopy(value.getBytes(), 0, bytes, this.par.getPosition().getBytePos(), value.length());
        this.reg.setValue(bytes);
    }

    @Override
    public String getDefault() {
        return this.par.getDefault();
    }
}

