/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp.definition;

import me.legrange.panstamp.DeviceLibrary;
import me.legrange.panstamp.DeviceNotFoundException;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.definition.DeviceDefinition;

public final class CompoundDeviceLibrary
implements DeviceLibrary {
    private final DeviceLibrary[] sources;

    public CompoundDeviceLibrary(DeviceLibrary ... sources) {
        this.sources = sources;
    }

    @Override
    public boolean hasDeviceDefinition(int manufacturedID, int productId) throws NetworkException {
        for (DeviceLibrary lib : this.sources) {
            if (!lib.hasDeviceDefinition(manufacturedID, productId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DeviceDefinition getDeviceDefinition(int manufacturedID, int productId) throws NetworkException {
        for (DeviceLibrary lib : this.sources) {
            if (!lib.hasDeviceDefinition(manufacturedID, productId)) continue;
            return lib.getDeviceDefinition(manufacturedID, productId);
        }
        throw new DeviceNotFoundException(String.format("Could not find device definition for manufacturer/product %d/%d", manufacturedID, productId));
    }
}

