/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import me.legrange.panstamp.xml.FileLibrary;
import me.legrange.panstamp.xml.XmlDeviceLibrary;

public class HttpLibrary
extends XmlDeviceLibrary {
    private final URL siteUrl;
    private static final Logger log = Logger.getLogger(FileLibrary.class.getName());

    public HttpLibrary(URL url) {
        this.siteUrl = url;
    }

    @Override
    InputStream getStream(String path) {
        try {
            return new URL(this.siteUrl, path).openStream();
        }
        catch (MalformedURLException ex) {
            log.warning(String.format("HTTP device file '%s' for does not exist under '%s'.", path, this.siteUrl.toString()));
        }
        catch (IOException ex) {
            log.warning(String.format("Error loading http device file: %s", ex.getMessage()));
        }
        return null;
    }
}

