/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.legrange.panstamp.definition.DeveloperDefinition;
import me.legrange.panstamp.definition.DeviceDefinition;
import me.legrange.panstamp.definition.RegisterDefinition;
import me.legrange.panstamp.xml.XmlDeveloperDefinition;
import me.legrange.panstamp.xml.XmlRegisterDefinition;

final class XmlDeviceDefinition
implements DeviceDefinition {
    private final int id;
    private final XmlDeveloperDefinition developer;
    private final String name;
    private final String label;
    private String product;
    private boolean powerDownMode;
    private final Map<Integer, XmlRegisterDefinition> registers = new HashMap<Integer, XmlRegisterDefinition>();

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public DeveloperDefinition getDeveloper() {
        return this.developer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getProduct() {
        return this.product;
    }

    @Override
    public boolean isPowerDownMode() {
        return this.powerDownMode;
    }

    @Override
    public List<RegisterDefinition> getRegisters() {
        ArrayList<RegisterDefinition> res = new ArrayList<RegisterDefinition>();
        res.addAll(this.registers.values());
        return res;
    }

    @Override
    public boolean hasRegister(int id) {
        return this.registers.get(id) != null;
    }

    @Override
    public RegisterDefinition getRegister(int id) {
        return this.registers.get(id);
    }

    public String toString() {
        return "Device{id=" + this.id + ", developer=" + this.developer + ", name=" + this.name + ", label=" + this.label + ", product=" + this.product + ", powerDownMode=" + this.powerDownMode + '}';
    }

    XmlDeviceDefinition(XmlDeveloperDefinition developer, int id, String name, String label) {
        this.id = id;
        this.developer = developer;
        this.name = name;
        this.label = label;
    }

    void setProduct(String product) {
        this.product = product;
    }

    void setPowerDownMode(Boolean pdm) {
        this.powerDownMode = pdm;
    }

    void addRegister(XmlRegisterDefinition rd) {
        this.registers.put(rd.getId(), rd);
    }
}

