/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp.xml;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.legrange.panstamp.DeviceLibrary;
import me.legrange.panstamp.DeviceNotFoundException;
import me.legrange.panstamp.NetworkException;
import me.legrange.panstamp.definition.DeviceDefinition;
import me.legrange.panstamp.xml.ParseException;
import me.legrange.panstamp.xml.XmlDeviceDefinition;
import me.legrange.panstamp.xml.XmlParser;

abstract class XmlDeviceLibrary
implements DeviceLibrary {
    private Map<String, XmlDeviceDefinition> devices;

    XmlDeviceLibrary() {
    }

    @Override
    public boolean hasDeviceDefinition(int manufacturedID, int productId) throws NetworkException {
        return this.getDefinition(manufacturedID, productId) != null;
    }

    @Override
    public DeviceDefinition getDeviceDefinition(int manufacturedID, int productId) throws NetworkException {
        XmlDeviceDefinition def = this.getDefinition(manufacturedID, productId);
        if (def == null) {
            throw new DeviceNotFoundException(String.format("Could not find device definition for manufacturer/product %d/%d", manufacturedID, productId));
        }
        return def;
    }

    abstract InputStream getStream(String var1);

    private synchronized XmlDeviceDefinition getDefinition(int manufacturedID, int productId) throws DeviceNotFoundException, ParseException {
        if (this.devices == null) {
            this.devices = new HashMap<String, XmlDeviceDefinition>();
            List<XmlDeviceDefinition> all = XmlParser.parse(this);
            for (XmlDeviceDefinition dev : all) {
                this.devices.put(this.makeId(dev.getDeveloper().getId(), dev.getId()), dev);
            }
        }
        return this.devices.get(this.makeId(manufacturedID, productId));
    }

    private String makeId(int manufacturedID, int productId) {
        return String.format("%d/%d", manufacturedID, productId);
    }
}

