/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import me.legrange.panstamp.definition.Direction;
import me.legrange.panstamp.definition.Position;
import me.legrange.panstamp.definition.Size;
import me.legrange.panstamp.definition.Type;
import me.legrange.panstamp.definition.Unit;
import me.legrange.panstamp.xml.ParseException;
import me.legrange.panstamp.xml.XmlDeveloperDefinition;
import me.legrange.panstamp.xml.XmlDeviceDefinition;
import me.legrange.panstamp.xml.XmlDeviceLibrary;
import me.legrange.panstamp.xml.XmlEndpointDefinition;
import me.legrange.panstamp.xml.XmlParameterDefinition;
import me.legrange.panstamp.xml.XmlRegisterDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class XmlParser {
    private final XmlDeviceLibrary lib;
    private static final Logger log = Logger.getLogger(XmlParser.class.getName());

    public static List<XmlDeviceDefinition> parse(XmlDeviceLibrary lib) throws ParseException {
        XmlParser parser = new XmlParser(lib);
        return parser.parseDevices();
    }

    private XmlParser(XmlDeviceLibrary lib) {
        this.lib = lib;
    }

    private List<XmlDeviceDefinition> parseDevices() throws ParseException {
        String fileName = "devices.xml";
        LinkedList<XmlDeviceDefinition> devices = new LinkedList<XmlDeviceDefinition>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.makeStream(fileName));
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals("devices")) {
                throw new ParseException(String.format("Excpected 'devices' element, but found '%s'", root.getNodeName()));
            }
            for (Element node : XmlParser.iterable(root.getElementsByTagName("developer"))) {
                devices.addAll(this.parseDeveloper(node));
            }
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new ParseException(String.format("XML error parsing '%s': %s", fileName, ex.getMessage()), ex);
        }
        catch (IOException ex) {
            throw new ParseException(String.format("IO error parsing '%s': %s", fileName, ex.getMessage()), ex);
        }
        return devices;
    }

    private List<XmlDeviceDefinition> parseDeveloper(Element node) throws ParseException {
        LinkedList<XmlDeviceDefinition> devices = new LinkedList<XmlDeviceDefinition>();
        int id = this.requireIntAttr(node, "id");
        String name = this.requireAttr(node, "name");
        XmlDeveloperDefinition dev = new XmlDeveloperDefinition(id, name);
        for (Element n : XmlParser.iterable(node.getChildNodes())) {
            XmlDeviceDefinition device;
            if (!n.getNodeName().equals("dev") || (device = this.parseDevice(dev, n)) == null) continue;
            devices.add(device);
        }
        return devices;
    }

    private XmlDeviceDefinition parseDevice(XmlDeveloperDefinition devel, Element node) throws ParseException {
        XmlDeviceDefinition dev = null;
        int id = this.requireIntAttr(node, "id");
        String name = this.requireAttr(node, "name");
        String label = this.requireAttr(node, "label");
        String fileName = devel.getName() + "/" + name + ".xml";
        InputStream in = this.makeStream(fileName);
        if (in != null) {
            dev = new XmlDeviceDefinition(devel, id, name, label);
            this.parseDeviceXML(dev, fileName);
        } else {
            log.warning(String.format("File '%s' for device id %d does not exist, skipping.", fileName, id));
        }
        return dev;
    }

    private void parseDeviceXML(XmlDeviceDefinition dev, String fileName) throws ParseException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.makeStream(fileName));
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals("device")) {
                throw new ParseException(String.format("Excpected 'device' element, but found '%s'", root.getNodeName()));
            }
            block17: for (Element node : XmlParser.iterable(root.getChildNodes())) {
                switch (node.getNodeName()) {
                    case "developer": {
                        continue block17;
                    }
                    case "product": {
                        dev.setProduct(node.getTextContent());
                        continue block17;
                    }
                    case "pwrdownmode": {
                        dev.setPowerDownMode(Boolean.valueOf(node.getTextContent()));
                        continue block17;
                    }
                    case "regular": {
                        this.parseRegular(dev, node);
                        continue block17;
                    }
                    case "config": {
                        this.parseConfig(dev, node);
                        continue block17;
                    }
                }
                throw new ParseException(String.format("Unexpected element '%s' in device file '%s'", node.getNodeName(), fileName));
            }
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new ParseException(String.format("XML error parsing '%s': %s", fileName, ex.getMessage()), ex);
        }
        catch (IOException ex) {
            throw new ParseException(String.format("IO error parsing '%s': %s", fileName, ex.getMessage()), ex);
        }
    }

    private void parseConfig(XmlDeviceDefinition dev, Element config) throws ParseException {
        block6: for (Element node : XmlParser.iterable(config.getChildNodes())) {
            switch (node.getNodeName()) {
                case "reg": {
                    dev.addRegister(this.parseConfigReg(dev, node));
                    continue block6;
                }
            }
            throw new ParseException(String.format(String.format("Unexpected element '%s'", node.getNodeName()), new Object[0]));
        }
    }

    private XmlRegisterDefinition parseConfigReg(XmlDeviceDefinition dev, Element reg) throws ParseException {
        int id = this.requireIntAttr(reg, "id");
        String name = this.requireAttr(reg, "name");
        XmlRegisterDefinition register = new XmlRegisterDefinition(id, name);
        block6: for (Element node : XmlParser.iterable(reg.getChildNodes())) {
            switch (node.getNodeName()) {
                case "param": {
                    this.parseParam(register, node);
                    continue block6;
                }
            }
            throw new ParseException(String.format("Unexpected element '%s'", node.getNodeName()));
        }
        return register;
    }

    private void parseParam(XmlRegisterDefinition register, Element param) throws ParseException {
        String name = this.requireAttr(param, "name");
        Type type = Type.forTag(this.requireAttr(param, "type"));
        if (type == null) {
            throw new ParseException(String.format("Unexpected param type '%s'", this.requireAttr(param, "type")));
        }
        XmlParameterDefinition par = new XmlParameterDefinition(name, type);
        block12: for (Element node : XmlParser.iterable(param.getChildNodes())) {
            switch (node.getNodeName()) {
                case "position": {
                    this.parsePosition(par, node);
                    continue block12;
                }
                case "size": {
                    this.parseSize(par, node);
                    continue block12;
                }
                case "default": {
                    par.setDefault(this.requireText(node));
                    continue block12;
                }
                case "verif": {
                    par.setVerif(this.requireText(node));
                    continue block12;
                }
            }
            throw new ParseException(String.format("Unexpected element '%s' in element '%s'", node.getNodeName(), param.getNodeName()));
        }
        register.addParameter(par);
    }

    private void parsePosition(XmlParameterDefinition par, Element pos) throws ParseException {
        String text = this.requireText(pos);
        try {
            if (text.matches("[0-9]+\\.[0-9]+")) {
                String[] parts = text.split("\\.");
                par.setPosition(new Position(Integer.parseInt(parts[0]), Integer.parseInt(parts[1])));
            } else {
                par.setPosition(new Position(Integer.parseInt(text)));
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException(String.format("Value for '%s' is not an integer", pos.getNodeName()), e);
        }
    }

    private void parseSize(XmlParameterDefinition par, Element pos) throws ParseException {
        String text = this.requireText(pos);
        try {
            if (text.matches("[0-9]+\\.[0-9]+")) {
                String[] parts = text.split("\\.");
                par.setSize(new Size(Integer.parseInt(parts[0]), Integer.parseInt(parts[1])));
            } else {
                par.setSize(new Size(Integer.parseInt(text), 0));
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException(String.format("Value for '%s' is not an integer", pos.getNodeName()), e);
        }
    }

    private void parseRegular(XmlDeviceDefinition dev, Element regular) throws ParseException {
        block6: for (Element node : XmlParser.iterable(regular.getChildNodes())) {
            switch (node.getNodeName()) {
                case "reg": {
                    dev.addRegister(this.parseRegularReg(dev, node));
                    continue block6;
                }
            }
            throw new ParseException(String.format("Unexpected element '%s'", node.getNodeName()));
        }
    }

    private XmlRegisterDefinition parseRegularReg(XmlDeviceDefinition dev, Element reg) throws ParseException {
        int id = this.requireIntAttr(reg, "id");
        String name = this.requireAttr(reg, "name");
        XmlRegisterDefinition register = new XmlRegisterDefinition(id, name);
        block6: for (Element node : XmlParser.iterable(reg.getChildNodes())) {
            switch (node.getNodeName()) {
                case "endpoint": {
                    register.addEndpoint(this.parseEndpoint(register, node));
                    continue block6;
                }
            }
            throw new ParseException(String.format("Unexpected element '%s'", node.getNodeName()));
        }
        return register;
    }

    private XmlEndpointDefinition parseEndpoint(XmlRegisterDefinition register, Element endp) throws ParseException {
        String name = this.requireAttr(endp, "name");
        Type type = Type.forTag(this.requireAttr(endp, "type"));
        if (type == null) {
            throw new ParseException(String.format("Unexpected endpoint type '%s'", this.requireAttr(endp, "type")));
        }
        Direction dir = Direction.forTag(this.requireAttr(endp, "dir"));
        if (dir == null) {
            throw new ParseException(String.format("Unexpected endpoint direction '%s'", this.requireAttr(endp, "dir")));
        }
        XmlEndpointDefinition endpoint = new XmlEndpointDefinition(register, name, dir, type);
        block10: for (Element node : XmlParser.iterable(endp.getChildNodes())) {
            switch (node.getNodeName()) {
                case "position": {
                    this.parsePosition(endpoint, node);
                    continue block10;
                }
                case "size": {
                    this.parseSize(endpoint, node);
                    continue block10;
                }
                case "units": {
                    this.parseUnits(endpoint, node);
                    continue block10;
                }
            }
            throw new ParseException(String.format("Unexpected element '%s' in element '%s'", node.getNodeName(), endp.getNodeName()));
        }
        return endpoint;
    }

    private void parsePosition(XmlEndpointDefinition endpoint, Element pos) throws ParseException {
        String text = this.requireText(pos);
        try {
            if (text.matches("[0-9]+\\.[0-9]+")) {
                String[] parts = text.split("\\.");
                endpoint.setPosition(new Position(Integer.parseInt(parts[0]), Integer.parseInt(parts[1])));
            } else {
                endpoint.setPosition(new Position(Integer.parseInt(text)));
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException(String.format("Value for '%s' is not an integer", pos.getNodeName()), e);
        }
    }

    private void parseSize(XmlEndpointDefinition endpoint, Element pos) throws ParseException {
        String text = this.requireText(pos);
        try {
            if (text.matches("[0-9]+\\.[0-9]+")) {
                String[] parts = text.split("\\.");
                endpoint.setSize(new Size(Integer.parseInt(parts[0]), Integer.parseInt(parts[1])));
            } else {
                endpoint.setSize(new Size(Integer.parseInt(text), 0));
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException(String.format("Value for '%s' is not an integer", pos.getNodeName()), e);
        }
    }

    private void parseUnits(XmlEndpointDefinition endpoint, Element units) throws ParseException {
        block6: for (Element node : XmlParser.iterable(units.getChildNodes())) {
            switch (node.getNodeName()) {
                case "unit": {
                    this.parseUnit(endpoint, node);
                    continue block6;
                }
            }
            throw new ParseException(String.format("Unexpected element '%s'", node.getNodeName()));
        }
    }

    private void parseUnit(XmlEndpointDefinition endpoint, Element u) throws ParseException {
        String name = "";
        if (u.hasAttribute("name")) {
            name = u.getAttribute("name");
        }
        double factor = this.requireDoubleAttr(u, "factor");
        double offset = this.requireDoubleAttr(u, "offset");
        endpoint.addUnit(new Unit(name, factor, offset));
    }

    private String requireText(Element node) throws ParseException {
        String text = node.getTextContent().trim();
        if (text == null || text.equals("")) {
            throw new ParseException(String.format("Text for node '%s' is empty", node.getNodeName()));
        }
        return text;
    }

    private int requireIntText(Element node) throws ParseException {
        try {
            return Integer.parseInt(this.requireText(node));
        }
        catch (NumberFormatException e) {
            throw new ParseException(String.format("Value for '%s' is not an integer", node.getNodeName()), e);
        }
    }

    private String requireAttr(Element node, String name) throws ParseException {
        if (!node.hasAttribute(name)) {
            throw new ParseException(String.format("Attribute '%s' is not defined on node '%s'", name, node.getNodeName()));
        }
        String text = node.getAttribute(name);
        if (text == null || text.equals("")) {
            throw new ParseException(String.format("Attribute '%s' is not defined", name));
        }
        return text;
    }

    private int requireIntAttr(Element node, String name) throws ParseException {
        try {
            return Integer.parseInt(this.requireAttr(node, name));
        }
        catch (NumberFormatException e) {
            throw new ParseException(String.format("Attribute '%s' is not an integer", name), e);
        }
    }

    private double requireDoubleAttr(Element node, String name) throws ParseException {
        try {
            return Double.parseDouble(this.requireAttr(node, name));
        }
        catch (NumberFormatException e) {
            throw new ParseException(String.format("Attribute '%s' is not a number", name), e);
        }
    }

    private InputStream makeStream(String fileName) {
        return this.lib.getStream(fileName);
    }

    private static Iterable<Element> iterable(NodeList nl) {
        LinkedList<Element> els = new LinkedList<Element>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            els.add((Element)n);
        }
        return els;
    }
}

