/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.panstamp.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.legrange.panstamp.definition.EndpointDefinition;
import me.legrange.panstamp.definition.ParameterDefinition;
import me.legrange.panstamp.definition.RegisterDefinition;
import me.legrange.panstamp.xml.XmlEndpointDefinition;
import me.legrange.panstamp.xml.XmlParameterDefinition;

final class XmlRegisterDefinition
implements RegisterDefinition {
    private final int id;
    private final String name;
    private final Map<String, XmlEndpointDefinition> endpoints = new HashMap<String, XmlEndpointDefinition>();
    private final Map<String, XmlParameterDefinition> params = new HashMap<String, XmlParameterDefinition>();

    public XmlRegisterDefinition(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<EndpointDefinition> getEndpoints() {
        ArrayList<EndpointDefinition> all = new ArrayList<EndpointDefinition>();
        all.addAll(this.endpoints.values());
        return all;
    }

    @Override
    public List<ParameterDefinition> getParameters() {
        ArrayList<ParameterDefinition> all = new ArrayList<ParameterDefinition>();
        all.addAll(this.params.values());
        return all;
    }

    @Override
    public int getByteSize() {
        int size = 0;
        for (EndpointDefinition epDef : this.getEndpoints()) {
            size += epDef.getSize().getBytes();
        }
        return size;
    }

    protected void addEndpoint(XmlEndpointDefinition ep) {
        this.endpoints.put(ep.getName(), ep);
    }

    void addParameter(XmlParameterDefinition par) {
        this.params.put(par.getName(), par);
    }
}

