/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.swap;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import me.legrange.swap.SerialException;

final class ComPort {
    private BufferedReader in;
    private OutputStream out;
    private SerialPort port;
    private final Object inLock = new Object();
    private final Object outLock = new Object();
    private static final int timeout = 60000;

    static ComPort open(String portName, int speed) throws SerialException {
        ComPort port = new ComPort();
        port.findAndOpen(portName, speed);
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(String msg) throws SerialException {
        try {
            Object object = this.outLock;
            synchronized (object) {
                this.out.write(msg.getBytes());
                this.out.flush();
            }
        }
        catch (IOException ex) {
            throw new SerialException("IO error sending data to serial port: " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String read() throws SerialException {
        try {
            Object object = this.inLock;
            synchronized (object) {
                return this.in.readLine();
            }
        }
        catch (IOException ex) {
            throw new SerialException("IO error reading data from serial port: " + ex.getMessage(), ex);
        }
    }

    void close() throws SerialException {
        try {
            this.in.close();
            this.out.close();
            this.port.close();
        }
        catch (IOException ex) {
            throw new SerialException(ex.getMessage(), ex);
        }
    }

    private ComPort() {
    }

    private void findAndOpen(String portName, int baudRate) throws SerialException {
        CommPortIdentifier portId;
        try {
            portId = CommPortIdentifier.getPortIdentifier((String)portName);
        }
        catch (NoSuchPortException ex) {
            throw new SerialException(String.format("Could not find serial port '%s'", portName), ex);
        }
        try {
            this.port = portId.open(this.getClass().getSimpleName(), 60000);
            this.port.setSerialPortParams(baudRate, 8, 1, 0);
            this.port.setFlowControlMode(0);
            this.port.enableReceiveTimeout(Integer.MAX_VALUE);
            this.port.enableReceiveThreshold(0);
            this.in = new BufferedReader(new InputStreamReader(this.port.getInputStream()));
            this.out = this.port.getOutputStream();
            this.out.flush();
        }
        catch (PortInUseException ex) {
            throw new SerialException(String.format("Serial port '%s' is in use", portName), ex);
        }
        catch (UnsupportedCommOperationException | IOException ex) {
            throw new SerialException(String.format("Error accessing serial port '%s': %s", portName, ex.getMessage()), ex);
        }
    }
}

