/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.swap;

import me.legrange.swap.DecodingException;
import me.legrange.swap.SwapMessage;

public class SerialMessage
implements SwapMessage {
    private final SwapMessage.Type type;
    private final boolean extended;
    private final int rssi;
    private final int lqi;
    private final int sender;
    private final int receiver;
    private final int hops;
    private final int security;
    private final int securityNonce;
    private final int registerAddress;
    private final int registerID;
    private final byte[] registerValue;
    private final String text;

    @Override
    public SwapMessage.Type getType() {
        return this.type;
    }

    @Override
    public int getFunction() {
        return this.type.function();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int getRssi() {
        return this.rssi;
    }

    @Override
    public int getLqi() {
        return this.lqi;
    }

    @Override
    public int getSender() {
        return this.sender;
    }

    @Override
    public int getReceiver() {
        return this.receiver;
    }

    @Override
    public int getHops() {
        return this.hops;
    }

    @Override
    public int getSecurity() {
        return this.security;
    }

    @Override
    public int getSecurityNonce() {
        return this.securityNonce;
    }

    @Override
    public int getRegisterAddress() {
        return this.registerAddress;
    }

    @Override
    public int getRegisterID() {
        return this.registerID;
    }

    @Override
    public byte[] getRegisterValue() {
        return this.registerValue;
    }

    @Override
    public boolean isExtended() {
        return this.extended;
    }

    @Override
    public boolean isStandardRegister() {
        return this.getRegisterID() <= 10;
    }

    public String toString() {
        return this.text;
    }

    public SerialMessage(String text) throws DecodingException {
        this.text = text;
        text = text.contains("(") ? text.replace("(", "").replace(")", "") : "0000" + text;
        int[] data = new int[text.length() / 2];
        for (int i = 0; i < text.length(); i += 2) {
            try {
                data[i / 2] = Integer.parseInt("" + text.charAt(i) + text.charAt(i + 1), 16);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new DecodingException(String.format("Invalid numeric data: '%s' (%02x %02x)", text, (int)text.charAt(i), (int)text.charAt(i + 1)), ex);
            }
        }
        int func = data[6];
        this.extended = (func & 0x80) != 0;
        switch (func &= 0x7F) {
            case 0: {
                this.type = SwapMessage.Type.STATUS;
                break;
            }
            case 1: {
                this.type = SwapMessage.Type.QUERY;
                break;
            }
            case 2: {
                this.type = SwapMessage.Type.COMMAND;
                break;
            }
            default: {
                throw new DecodingException(String.format("Unknown function code 0x%x (message: '%s')", func, text));
            }
        }
        this.rssi = data[0];
        this.lqi = data[1];
        this.hops = (data[4] & 0xF0) >> 4;
        this.security = data[4] & 0xF;
        this.securityNonce = data[5];
        byte[] value = new byte[data.length - 9];
        if (this.extended) {
            this.receiver = data[7] << 8 | data[8];
            this.sender = data[2] << 8 | data[3];
            this.registerAddress = data[9] << 8 | data[10];
            this.registerID = data[10];
            if (data.length > 9) {
                for (int i = 0; i < value.length; ++i) {
                    value[i] = (byte)data[12 + i];
                }
            }
        } else {
            this.sender = data[3];
            this.receiver = data[2];
            this.registerAddress = data[7];
            this.registerID = data[8];
            if (data.length > 9) {
                for (int i = 0; i < value.length; ++i) {
                    value[i] = (byte)data[9 + i];
                }
            }
        }
        this.registerValue = value;
    }
}

