/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.swap;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.legrange.swap.ComPort;
import me.legrange.swap.DecodingException;
import me.legrange.swap.MessageListener;
import me.legrange.swap.ModemSetup;
import me.legrange.swap.SerialException;
import me.legrange.swap.SerialMessage;
import me.legrange.swap.SwapException;
import me.legrange.swap.SwapMessage;
import me.legrange.swap.SwapModem;

public final class SerialModem
implements SwapModem {
    private ComPort com;
    private Mode mode = Mode.DATA;
    private ModemSetup setup;
    private final BlockingQueue<String> results = new LinkedBlockingQueue<String>();
    private Reader reader;
    private boolean running;
    private final List<MessageListener> listeners = new CopyOnWriteArrayList<MessageListener>();
    private final int baud;
    private final String port;
    private final ExecutorService pool = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "SWAP Listener Notification");
            t.setDaemon(true);
            return t;
        }
    });

    public SerialModem(String port, int baud) {
        this.port = port;
        this.baud = baud;
    }

    @Override
    public void open() throws SwapException {
        this.com = ComPort.open(this.port, this.baud);
        this.running = true;
        this.reader = new Reader();
        this.reader.setDaemon(true);
        this.reader.setName(String.format("%s Reader Thread", this.getClass().getSimpleName()));
        this.reader.start();
        if (this.setup != null) {
            this.setSetup(this.setup);
        }
    }

    @Override
    public void close() throws SerialException {
        this.running = false;
        this.com.close();
    }

    @Override
    public boolean isOpen() {
        return this.running;
    }

    @Override
    public synchronized void send(SwapMessage msg) throws SerialException {
        this.com.send(msg.getText() + "\r");
        this.fireEvent(msg, ReceiveTask.Direction.OUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MessageListener l) {
        List<MessageListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MessageListener l) {
        List<MessageListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModemSetup getSetup() throws SerialException {
        if (this.setup == null) {
            if (this.running) {
                SerialModem serialModem = this;
                synchronized (serialModem) {
                    this.enterCommandMode();
                    this.setup = new ModemSetup(this.readATasInt("ATCH?"), this.readATasHex("ATSW?"), this.readATasHex("ATDA?"));
                    this.leaveCommandMode();
                }
            } else {
                this.setup = new ModemSetup(0, 0, 0);
            }
        }
        return this.setup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSetup(ModemSetup setup) throws SerialException {
        SerialModem serialModem = this;
        synchronized (serialModem) {
            if (this.running) {
                this.enterCommandMode();
                this.sendATCommand(String.format("ATCH=%2d", setup.getChannel()));
                this.sendATCommand(String.format("ATSW=%4h", setup.getNetworkID()));
                this.sendATCommand(String.format("ATDA=%2d", setup.getDeviceAddress()));
                this.leaveCommandMode();
            }
            this.setup = setup;
        }
    }

    @Override
    public SwapModem.Type getType() {
        return SwapModem.Type.SERIAL;
    }

    public String getPort() {
        return this.port;
    }

    public int getBaud() {
        return this.baud;
    }

    private int readATasInt(String cmd) throws SerialException {
        String res = this.readAT(cmd);
        try {
            return Integer.parseInt(res);
        }
        catch (NumberFormatException e) {
            throw new SerialException(String.format("Malformed integer response '%s' to %s comamnd", res, cmd));
        }
    }

    private int readATasHex(String cmd) throws SerialException {
        String res = this.readAT(cmd);
        try {
            return Integer.parseInt(res, 16);
        }
        catch (NumberFormatException e) {
            throw new SerialException(String.format("Malformed hex response '%s' to %s comamnd", res, cmd));
        }
    }

    private String readAT(String cmd) throws SerialException {
        String res;
        switch (res = this.sendATCommand(cmd)) {
            case "ERROR": {
                throw new SerialException(String.format("Error on %s command", cmd));
            }
            case "OK": {
                throw new SerialException(String.format("Unexpected OK in %s command", cmd));
            }
        }
        return res;
    }

    private void enterCommandMode() throws SerialException {
        if (this.mode == Mode.COMMAND) {
            return;
        }
        while (this.mode == Mode.INIT) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SerialModem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (int count = 3; count > 0; --count) {
            if (!this.tryCommandMode()) continue;
            return;
        }
        throw new SerialException("Timed out waiting for command mode");
    }

    private boolean tryCommandMode() throws SerialException {
        this.com.send("+++");
        for (int count = 0; this.mode != Mode.COMMAND && count < 15; ++count) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                if (this.running) continue;
                throw new SerialException("Modem stopped while entering command mode");
            }
        }
        return this.mode == Mode.COMMAND;
    }

    private void leaveCommandMode() throws SerialException {
        if (this.mode == Mode.DATA) {
            return;
        }
        this.com.send("ATO\r");
        while (this.mode != Mode.DATA) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private String sendATCommand(String cmd) throws SerialException {
        this.com.send(cmd + "\r");
        try {
            return this.results.take();
        }
        catch (InterruptedException ex) {
            throw new SerialException("Interruped waiting for AT response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(SwapMessage msg, ReceiveTask.Direction dir) {
        List<MessageListener> list = this.listeners;
        synchronized (list) {
            for (MessageListener l : this.listeners) {
                this.pool.submit(new ReceiveTask(l, msg, dir));
            }
        }
    }

    private static class ReceiveTask
    implements Runnable {
        private final SwapMessage msg;
        private final MessageListener l;
        private final Direction dir;

        private ReceiveTask(MessageListener listener, SwapMessage msg, Direction dir) {
            this.msg = msg;
            this.l = listener;
            this.dir = dir;
        }

        @Override
        public void run() {
            try {
                if (this.dir == Direction.IN) {
                    this.l.messageReceived(this.msg);
                } else {
                    this.l.messageSent(this.msg);
                }
            }
            catch (Throwable e) {
                Logger.getLogger(SerialModem.class.getName()).log(Level.SEVERE, null, e);
            }
        }

        private static enum Direction {
            IN,
            OUT;

        }
    }

    private class Reader
    extends Thread {
        private Reader() {
        }

        @Override
        public void run() {
            block15: while (SerialModem.this.running) {
                try {
                    String in = SerialModem.this.com.read();
                    if (in.length() == 0) continue;
                    if (in.length() >= 12 && in.startsWith("(")) {
                        SerialModem.this.mode = Mode.DATA;
                        SerialModem.this.fireEvent(new SerialMessage(in), ReceiveTask.Direction.IN);
                        continue;
                    }
                    switch (in) {
                        case "OK-Command mode": {
                            SerialModem.this.mode = Mode.COMMAND;
                            continue block15;
                        }
                        case "Modem ready!": 
                        case "OK-Data mode": {
                            SerialModem.this.mode = Mode.DATA;
                            continue block15;
                        }
                    }
                    SerialModem.this.results.add(in);
                }
                catch (SerialException ex) {
                    Logger.getLogger(SerialModem.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (DecodingException ex) {
                    Logger.getLogger(SerialModem.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (Throwable ex) {
                    Logger.getLogger(SerialModem.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private static enum Mode {
        INIT,
        DATA,
        COMMAND;

    }
}

