/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.swap;

import me.legrange.swap.SwapMessage;

public class UserMessage
implements SwapMessage {
    private final SwapMessage.Type type;
    private final boolean extended;
    private final int sender;
    private final int receiver;
    private int security;
    private int securityNonce;
    private int registerAddress;
    private final int registerID;
    private final byte[] registerValue;
    private String text;

    public UserMessage(boolean extended, SwapMessage.Type type, int sender, int receiver, int registerID, byte[] registerValue) {
        this.extended = extended;
        this.type = type;
        this.sender = sender;
        this.receiver = receiver;
        this.registerAddress = receiver;
        this.registerID = registerID;
        this.registerValue = registerValue;
    }

    @Override
    public int getFunction() {
        return this.type.function();
    }

    @Override
    public boolean isStandardRegister() {
        return this.getRegisterID() <= 10;
    }

    @Override
    public SwapMessage.Type getType() {
        return this.type;
    }

    @Override
    public boolean isExtended() {
        return this.extended;
    }

    @Override
    public int getRssi() {
        return 0;
    }

    @Override
    public int getLqi() {
        return 0;
    }

    @Override
    public int getSender() {
        return this.sender;
    }

    @Override
    public int getReceiver() {
        return this.receiver;
    }

    @Override
    public int getHops() {
        return 0;
    }

    @Override
    public int getSecurity() {
        return this.security;
    }

    @Override
    public int getSecurityNonce() {
        return this.securityNonce;
    }

    @Override
    public int getRegisterAddress() {
        return this.registerAddress;
    }

    @Override
    public int getRegisterID() {
        return this.registerID;
    }

    @Override
    public byte[] getRegisterValue() {
        return this.registerValue;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = this.pack();
        }
        return this.text;
    }

    public String toString() {
        return this.getText();
    }

    public void setSecurity(int security) {
        this.security = security;
        this.text = null;
    }

    public void setSecurityNonce(int securityNonce) {
        this.securityNonce = securityNonce;
        this.text = null;
    }

    public void setRegisterAddress(int registerAddress) {
        this.registerAddress = registerAddress;
        this.text = null;
    }

    private String pack() {
        int[] data = this.extended ? this.packExtended() : this.packStandard();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            buf.append(String.format("%02X", data[i]));
        }
        return buf.toString();
    }

    private int[] packStandard() {
        int[] data = new int[7 + this.getRegisterValue().length];
        data[0] = this.getReceiver();
        data[1] = this.getSender();
        data[2] = this.getHops() << 4 | this.getSecurity();
        data[3] = this.getSecurityNonce();
        data[4] = this.getFunction();
        data[5] = this.getRegisterAddress();
        data[6] = this.getRegisterID();
        if (this.type != SwapMessage.Type.QUERY) {
            byte[] value = this.getRegisterValue();
            for (int i = 0; i < value.length; ++i) {
                int v = value[i];
                data[i + 7] = v < 0 ? 256 + v : v;
            }
        }
        return data;
    }

    private int[] packExtended() {
        int[] data = new int[10 + this.getRegisterValue().length];
        data[0] = this.getReceiver() & 0xFF;
        data[1] = this.getReceiver() & 0xFF;
        data[2] = this.getHops() << 4 | this.getSecurity();
        data[3] = this.getSecurityNonce();
        data[4] = this.getFunction();
        data[5] = this.getSender() & 0xFF;
        data[6] = this.getSender() & 0xFF;
        data[7] = this.getRegisterAddress() & 0xFF;
        data[8] = this.getRegisterAddress() & 0xFF;
        data[9] = this.getRegisterID();
        if (this.type != SwapMessage.Type.QUERY) {
            byte[] value = this.getRegisterValue();
            for (int i = 0; i < value.length; ++i) {
                int v = value[i];
                data[i + 10] = v < 0 ? 256 + v : v;
            }
        }
        return data;
    }
}

