/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.swap.tcp;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.legrange.swap.MessageListener;
import me.legrange.swap.ModemSetup;
import me.legrange.swap.SerialModem;
import me.legrange.swap.SwapException;
import me.legrange.swap.SwapMessage;
import me.legrange.swap.SwapModem;
import me.legrange.swap.tcp.TcpException;
import me.legrange.swap.tcp.TcpListener;
import me.legrange.swap.tcp.TcpTransport;

public class TcpModem
implements SwapModem {
    private Socket sock;
    private final String host;
    private final int port;
    private TcpTransport trans;
    private boolean running;
    private final List<MessageListener> listeners = new CopyOnWriteArrayList<MessageListener>();
    private ModemSetup setup;
    private Listener listener;
    private final ExecutorService pool = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "SWAP Listener Notification");
            t.setDaemon(true);
            return t;
        }
    });

    public TcpModem(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public void open() throws TcpException {
        try {
            this.running = true;
            this.setup = new ModemSetup(0, 0, 0);
            this.sock = new Socket(this.host, this.port);
            this.trans = new TcpTransport(this.sock);
            this.listener = new Listener();
            this.trans.addListener(this.listener);
        }
        catch (IOException ex) {
            throw new TcpException(ex.getMessage(), ex);
        }
    }

    @Override
    public void close() throws SwapException {
        this.running = false;
        try {
            this.trans.close();
            this.sock.close();
        }
        catch (IOException ex) {
            throw new TcpException(ex.getMessage(), ex);
        }
        finally {
            this.trans.removeListener(this.listener);
        }
    }

    @Override
    public boolean isOpen() {
        return this.running;
    }

    @Override
    public void send(SwapMessage msg) throws SwapException {
        this.trans.sendMessage(msg);
    }

    @Override
    public void addListener(MessageListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(MessageListener l) {
        this.listeners.remove(l);
    }

    @Override
    public ModemSetup getSetup() throws SwapException {
        if (this.setup == null) {
            this.setup = new ModemSetup(0, 0, 0);
        }
        return this.setup;
    }

    @Override
    public void setSetup(ModemSetup newSetup) throws SwapException {
        this.trans.sendSetup(newSetup);
    }

    @Override
    public SwapModem.Type getType() {
        return SwapModem.Type.TCP_IP;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(SwapMessage msg, ReceiveTask.Direction dir) {
        List<MessageListener> list = this.listeners;
        synchronized (list) {
            for (MessageListener l : this.listeners) {
                this.pool.submit(new ReceiveTask(l, msg, dir));
            }
        }
    }

    private static class ReceiveTask
    implements Runnable {
        private final SwapMessage msg;
        private final MessageListener l;
        private final Direction dir;

        private ReceiveTask(MessageListener listener, SwapMessage msg, Direction dir) {
            this.msg = msg;
            this.l = listener;
            this.dir = dir;
        }

        @Override
        public void run() {
            try {
                if (this.dir == Direction.IN) {
                    this.l.messageReceived(this.msg);
                } else {
                    this.l.messageSent(this.msg);
                }
            }
            catch (Throwable e) {
                Logger.getLogger(SerialModem.class.getName()).log(Level.SEVERE, null, e);
            }
        }

        private static enum Direction {
            IN,
            OUT;

        }
    }

    private class Listener
    implements TcpListener {
        private Listener() {
        }

        @Override
        public void messgeReceived(SwapMessage msg) {
            TcpModem.this.fireEvent(msg, ReceiveTask.Direction.IN);
        }

        @Override
        public void setupReceived(ModemSetup newSetup) {
            TcpModem.this.setup = newSetup;
        }
    }
}

