/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.swap.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.legrange.swap.MessageListener;
import me.legrange.swap.ModemSetup;
import me.legrange.swap.SerialException;
import me.legrange.swap.SwapException;
import me.legrange.swap.SwapMessage;
import me.legrange.swap.SwapModem;
import me.legrange.swap.tcp.TcpException;
import me.legrange.swap.tcp.TcpListener;
import me.legrange.swap.tcp.TcpTransport;

public class TcpServer {
    private final SwapModem sm;
    private final ServerSocket sock;
    private final Service service;
    private final List<TcpTransport> sessions = new CopyOnWriteArrayList<TcpTransport>();
    private boolean running;

    public TcpServer(SwapModem sm, int port) throws TcpException {
        this.sm = sm;
        this.running = true;
        try {
            this.sock = new ServerSocket(port);
        }
        catch (IOException ex) {
            throw new TcpException(ex.getMessage(), ex);
        }
        this.service = new Service();
        this.service.start();
        sm.addListener(new SwapListener());
    }

    public void close() throws TcpException {
        this.running = false;
        try {
            this.sock.close();
        }
        catch (IOException ex) {
            throw new TcpException(ex.getMessage(), ex);
        }
    }

    private void sendSetup(TcpTransport tt) throws SerialException, SwapException {
        ModemSetup setup = this.sm.getSetup();
        tt.sendSetup(setup);
    }

    private void fireEvent(TcpTransport trans, SwapMessage msg) {
        for (TcpTransport t : this.sessions) {
            if (t == trans) continue;
            t.sendMessage(msg);
        }
    }

    private void fireEvent(TcpTransport trans, ModemSetup setup) {
        for (TcpTransport t : this.sessions) {
            if (t == trans) continue;
            t.sendSetup(setup);
        }
    }

    private class SwapListener
    implements MessageListener {
        private SwapListener() {
        }

        @Override
        public void messageReceived(SwapMessage msg) {
            for (TcpTransport tt : TcpServer.this.sessions) {
                if (!tt.isClosed()) {
                    tt.sendMessage(msg);
                    continue;
                }
                TcpServer.this.sessions.remove(tt);
            }
        }

        @Override
        public void messageSent(SwapMessage msg) {
            for (TcpTransport tt : TcpServer.this.sessions) {
                if (!tt.isClosed()) {
                    tt.sendMessage(msg);
                    continue;
                }
                TcpServer.this.sessions.remove(tt);
            }
        }
    }

    private class Service
    extends Thread {
        private Service() {
            super("TcpServer accept thread");
        }

        @Override
        public void run() {
            while (TcpServer.this.running) {
                try {
                    final TcpTransport trans = new TcpTransport(TcpServer.this.sock.accept());
                    trans.addListener(new TcpListener(){

                        @Override
                        public void messgeReceived(SwapMessage msg) {
                            try {
                                TcpServer.this.sm.send(msg);
                                TcpServer.this.fireEvent(trans, msg);
                            }
                            catch (SwapException ex) {
                                Logger.getLogger(TcpServer.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }

                        @Override
                        public void setupReceived(ModemSetup setup) {
                            try {
                                TcpServer.this.sm.setSetup(setup);
                                TcpServer.this.fireEvent(trans, setup);
                            }
                            catch (SwapException ex) {
                                Logger.getLogger(TcpServer.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    });
                    TcpServer.this.sessions.add(trans);
                    TcpServer.this.sendSetup(trans);
                }
                catch (IOException ex) {
                    Logger.getLogger(TcpServer.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SerialException ex) {
                    Logger.getLogger(TcpServer.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (SwapException ex) {
                    Logger.getLogger(TcpServer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

