/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.swap.tcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.legrange.swap.DecodingException;
import me.legrange.swap.ModemSetup;
import me.legrange.swap.SerialMessage;
import me.legrange.swap.SwapMessage;
import me.legrange.swap.tcp.TcpListener;

class TcpTransport {
    private static final String MESSAGE_START = "-";
    private static final String SETUP_START = "+";
    private static final String COMMAND_START = "!";
    private static final String SETUP_DEVICE_ADDRESS = "DA";
    private static final String SETUP_NETWORK_ID = "SW";
    private static final String SETUP_CHANNEL = "CH";
    private final Socket sock;
    private boolean running = true;
    private final BufferedReader in;
    private final PrintWriter out;
    private final Reader reader;
    private final List<TcpListener> listeners = new CopyOnWriteArrayList<TcpListener>();

    TcpTransport(Socket sock) throws IOException {
        this.sock = sock;
        this.in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
        this.out = new PrintWriter(new OutputStreamWriter(sock.getOutputStream()));
        this.reader = new Reader();
        this.start();
    }

    boolean isClosed() {
        return this.sock.isClosed();
    }

    void addListener(TcpListener l) {
        this.listeners.add(l);
    }

    void removeListener(TcpListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessage(SwapMessage msg) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.write(MESSAGE_START);
            this.out.write(msg.getText());
            this.out.write("\n");
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendSetup(ModemSetup setup) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.write(SETUP_START);
            this.out.write(String.format("%s=%d,", SETUP_DEVICE_ADDRESS, setup.getDeviceAddress()));
            this.out.write(String.format("%s=%d,", SETUP_CHANNEL, setup.getChannel()));
            this.out.write(String.format("%s=%d", SETUP_NETWORK_ID, setup.getNetworkID()));
            this.out.write("\n");
            this.out.flush();
        }
    }

    void close() throws IOException {
        this.sendCommand("quit");
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(String cmd) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.write(COMMAND_START);
            this.out.write(cmd);
            this.out.write("\n");
            this.out.flush();
        }
    }

    private void start() {
        this.running = true;
        this.reader.start();
    }

    private void stop() throws IOException {
        this.running = false;
        this.in.close();
        this.out.close();
        this.sock.close();
        this.reader.interrupt();
        this.listeners.clear();
    }

    private void fireEvent(SwapMessage msg) {
        for (TcpListener l : this.listeners) {
            l.messgeReceived(msg);
        }
    }

    private void fireEvent(ModemSetup setup) {
        for (TcpListener l : this.listeners) {
            l.setupReceived(setup);
        }
    }

    private void decodeSetup(String line) {
        String[] parts;
        int addr = 0;
        int chan = 0;
        int netId = 0;
        block10: for (String part : parts = line.split(",")) {
            String name;
            String[] bits = part.split("=");
            if (bits.length != 2) continue;
            switch (name = bits[0]) {
                case "DA": {
                    addr = Integer.parseInt(bits[1]);
                    continue block10;
                }
                case "CH": {
                    chan = Integer.parseInt(bits[1]);
                    continue block10;
                }
                case "SW": {
                    netId = Integer.parseInt(bits[1]);
                }
            }
        }
        ModemSetup setup = new ModemSetup(chan, netId, addr);
        this.fireEvent(setup);
    }

    private void decodeCommand(String cmd) throws IOException {
        switch (cmd.toLowerCase()) {
            case "quit": {
                this.stop();
            }
        }
    }

    private class Reader
    extends Thread {
        private Reader() {
            super("TcpTransport reader");
        }

        @Override
        public void run() {
            while (TcpTransport.this.running) {
                try {
                    String c;
                    String line = TcpTransport.this.in.readLine();
                    if (line == null || line.length() <= 0) continue;
                    switch (c = line.substring(0, 1)) {
                        case "-": {
                            TcpTransport.this.fireEvent(new SerialMessage(line.substring(1)));
                            break;
                        }
                        case "+": {
                            TcpTransport.this.decodeSetup(line.substring(1));
                            break;
                        }
                        case "!": {
                            TcpTransport.this.decodeCommand(line.substring(1));
                            break;
                        }
                    }
                }
                catch (IOException | DecodingException ex) {
                    Logger.getLogger(TcpTransport.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

